/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.ChunkChunk;
import io.deephaven.chunk.ChunkChunkBase;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.attributes.Any;

public class ObjectChunkChunk<T, ATTR extends Any>
extends ChunkChunkBase<ATTR>
implements ChunkChunk<ATTR> {
    private static final ObjectChunkChunk EMPTY = new ObjectChunkChunk(new ObjectChunk[0], 0, 0);
    ObjectChunk<T, ATTR>[] data;
    T[][] innerData;
    int[] innerOffsets;

    public static <T, ATTR extends Any> ObjectChunkChunk<T, ATTR> getEmptyChunk() {
        return EMPTY;
    }

    public static <T, ATTR extends Any> ObjectChunk<T, ATTR>[] makeArray(int capacity) {
        return new ObjectChunk[capacity];
    }

    public static <T, ATTR extends Any> ObjectChunkChunk<T, ATTR> chunkWrap(ObjectChunk<T, ATTR>[] data) {
        return new ObjectChunkChunk<T, ATTR>(data, 0, data.length);
    }

    public static <T, ATTR extends Any> ObjectChunkChunk<T, ATTR> chunkWrap(ObjectChunk<T, ATTR>[] data, int offset, int capacity) {
        return new ObjectChunkChunk<T, ATTR>(data, offset, capacity);
    }

    ObjectChunkChunk(ObjectChunk<T, ATTR>[] data, int offset, int capacity) {
        super(data.length, offset, capacity);
        this.data = data;
        this.resetInnerCache(data, offset, 0, capacity);
    }

    final void resetInnerCache(ObjectChunk<T, ATTR>[] data, int offset, int oldCapacity, int newCapacity) {
        int ii;
        if (this.innerData == null || this.innerData.length < newCapacity) {
            this.innerData = new Object[newCapacity][];
            this.innerOffsets = new int[newCapacity];
        }
        for (ii = 0; ii < newCapacity; ++ii) {
            this.resetInnerCacheItem(ii, data[ii + offset]);
        }
        for (ii = newCapacity; ii < oldCapacity; ++ii) {
            this.innerData[ii] = null;
            this.innerOffsets[ii] = 0;
        }
    }

    final void resetInnerCacheItem(int index, ObjectChunk<T, ATTR> chunk) {
        if (chunk == null) {
            this.innerData[index] = null;
            this.innerOffsets[index] = 0;
        } else {
            this.innerData[index] = chunk.data;
            this.innerOffsets[index] = chunk.offset;
        }
    }

    public final ObjectChunk<T, ATTR> get(int index) {
        return this.data[this.offset + index];
    }

    public final ObjectChunk<T, ATTR> getChunk(int index) {
        return this.get(index);
    }

    public final T get(int j, int i) {
        return this.innerData[j][this.innerOffsets[j] + i];
    }

    public ObjectChunkChunk<T, ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new ObjectChunkChunk<T, ATTR>(this.data, this.offset + offset, capacity);
    }
}

