/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.attributes.Any;
import java.util.Arrays;

public class OrderedChunkUtils {
    public static <ATTR extends Any> int findInChunk(LongChunk<ATTR> chunk, long value) {
        return OrderedChunkUtils.findInChunk(chunk, value, 0, chunk.size());
    }

    public static <ATTR extends Any> int findInChunk(LongChunk<ATTR> chunk, long value, int startOffset, int endOffsetExclusive) {
        int retVal = Arrays.binarySearch(chunk.data, chunk.offset + startOffset, chunk.offset + endOffsetExclusive, value);
        retVal = retVal < 0 ? ~retVal : retVal;
        return Math.min(retVal - chunk.offset, chunk.size);
    }
}

