/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.BooleanChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.ResettableReadOnlyChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.pools.MultiChunkPool;
import io.deephaven.util.type.ArrayTypeUtils;

public class ResettableBooleanChunk<ATTR_UPPER extends Any>
extends BooleanChunk<ATTR_UPPER>
implements ResettableReadOnlyChunk<ATTR_UPPER> {
    public static <ATTR_BASE extends Any> ResettableBooleanChunk<ATTR_BASE> makeResettableChunk() {
        return new ResettableBooleanChunk();
    }

    public static <ATTR_BASE extends Any> ResettableBooleanChunk<ATTR_BASE> makeResettableChunkForPool() {
        return new ResettableBooleanChunk<ATTR_BASE>(){

            @Override
            public void close() {
                MultiChunkPool.forThisThread().giveResettableBooleanChunk(this);
            }
        };
    }

    private ResettableBooleanChunk(boolean[] data, int offset, int capacity) {
        super(data, offset, capacity);
    }

    private ResettableBooleanChunk() {
        this(ArrayTypeUtils.EMPTY_BOOLEAN_ARRAY, 0, 0);
    }

    @Override
    public ResettableBooleanChunk<ATTR_UPPER> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new ResettableBooleanChunk<ATTR_UPPER>(this.data, this.offset + offset, capacity);
    }

    @Override
    public <ATTR extends ATTR_UPPER> BooleanChunk<ATTR> resetFromChunk(Chunk<? extends ATTR> other, int offset, int capacity) {
        return this.resetFromTypedChunk(other.asBooleanChunk(), offset, capacity);
    }

    @Override
    public <ATTR extends ATTR_UPPER> BooleanChunk<ATTR> resetFromArray(Object array, int offset, int capacity) {
        boolean[] typedArray = (boolean[])array;
        return this.resetFromTypedArray(typedArray, offset, capacity);
    }

    @Override
    public <ATTR extends ATTR_UPPER> BooleanChunk<ATTR> resetFromArray(Object array) {
        boolean[] typedArray = (boolean[])array;
        return this.resetFromTypedArray(typedArray, 0, typedArray.length);
    }

    @Override
    public <ATTR extends ATTR_UPPER> BooleanChunk<ATTR> clear() {
        return this.resetFromArray(ArrayTypeUtils.EMPTY_BOOLEAN_ARRAY, 0, 0);
    }

    public <ATTR extends ATTR_UPPER> BooleanChunk<ATTR> resetFromTypedChunk(BooleanChunk<? extends ATTR> other, int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(other.size, offset, capacity);
        return this.resetFromTypedArray(other.data, other.offset + offset, capacity);
    }

    public <ATTR extends ATTR_UPPER> BooleanChunk<ATTR> resetFromTypedArray(boolean[] data, int offset, int capacity) {
        ChunkHelpers.checkArrayArgs(data.length, offset, capacity);
        this.data = data;
        this.offset = offset;
        this.capacity = capacity;
        this.size = capacity;
        return BooleanChunk.downcast(this);
    }

    public void close() {
    }
}

