/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.ResettableReadOnlyChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.pools.MultiChunkPool;
import io.deephaven.util.type.ArrayTypeUtils;

public class ResettableByteChunk<ATTR_UPPER extends Any>
extends ByteChunk<ATTR_UPPER>
implements ResettableReadOnlyChunk<ATTR_UPPER> {
    public static <ATTR_BASE extends Any> ResettableByteChunk<ATTR_BASE> makeResettableChunk() {
        return new ResettableByteChunk();
    }

    public static <ATTR_BASE extends Any> ResettableByteChunk<ATTR_BASE> makeResettableChunkForPool() {
        return new ResettableByteChunk<ATTR_BASE>(){

            @Override
            public void close() {
                MultiChunkPool.forThisThread().giveResettableByteChunk(this);
            }
        };
    }

    private ResettableByteChunk(byte[] data, int offset, int capacity) {
        super(data, offset, capacity);
    }

    private ResettableByteChunk() {
        this(ArrayTypeUtils.EMPTY_BYTE_ARRAY, 0, 0);
    }

    @Override
    public ResettableByteChunk<ATTR_UPPER> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new ResettableByteChunk<ATTR_UPPER>(this.data, this.offset + offset, capacity);
    }

    @Override
    public <ATTR extends ATTR_UPPER> ByteChunk<ATTR> resetFromChunk(Chunk<? extends ATTR> other, int offset, int capacity) {
        return this.resetFromTypedChunk(other.asByteChunk(), offset, capacity);
    }

    @Override
    public <ATTR extends ATTR_UPPER> ByteChunk<ATTR> resetFromArray(Object array, int offset, int capacity) {
        byte[] typedArray = (byte[])array;
        return this.resetFromTypedArray(typedArray, offset, capacity);
    }

    @Override
    public <ATTR extends ATTR_UPPER> ByteChunk<ATTR> resetFromArray(Object array) {
        byte[] typedArray = (byte[])array;
        return this.resetFromTypedArray(typedArray, 0, typedArray.length);
    }

    @Override
    public <ATTR extends ATTR_UPPER> ByteChunk<ATTR> clear() {
        return this.resetFromArray(ArrayTypeUtils.EMPTY_BYTE_ARRAY, 0, 0);
    }

    public <ATTR extends ATTR_UPPER> ByteChunk<ATTR> resetFromTypedChunk(ByteChunk<? extends ATTR> other, int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(other.size, offset, capacity);
        return this.resetFromTypedArray(other.data, other.offset + offset, capacity);
    }

    public <ATTR extends ATTR_UPPER> ByteChunk<ATTR> resetFromTypedArray(byte[] data, int offset, int capacity) {
        ChunkHelpers.checkArrayArgs(data.length, offset, capacity);
        this.data = data;
        this.offset = offset;
        this.capacity = capacity;
        this.size = capacity;
        return ByteChunk.downcast(this);
    }

    public void close() {
    }
}

