/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.ByteChunkChunk;
import io.deephaven.chunk.ChunkChunk;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.ResettableChunkChunk;
import io.deephaven.chunk.attributes.Any;

public class ResettableByteChunkChunk<ATTR extends Any>
extends ByteChunkChunk<ATTR>
implements ResettableChunkChunk<ATTR> {
    public static <ATTR extends Any> ResettableByteChunkChunk<ATTR> makeResettableChunk() {
        return new ResettableByteChunkChunk<ATTR>();
    }

    private ResettableByteChunkChunk(ByteChunk<ATTR>[] data, int offset, int capacity) {
        super(data, offset, capacity);
    }

    private ResettableByteChunkChunk() {
        this(ByteChunk.getEmptyChunkArray(), 0, 0);
    }

    @Override
    public ResettableByteChunkChunk<ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new ResettableByteChunkChunk<ATTR>(this.data, this.offset + offset, capacity);
    }

    @Override
    public final void resetFromChunk(ChunkChunk<ATTR> other, int offset, int capacity) {
        this.resetFromTypedChunk(other.asByteChunkChunk(), offset, capacity);
    }

    @Override
    public final void resetFromArray(Object array, int offset, int capacity) {
        ByteChunk[] typedArray = (ByteChunk[])array;
        this.resetFromTypedArray(typedArray, offset, capacity);
    }

    public final void resetFromTypedChunk(ByteChunkChunk<ATTR> other, int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(other.size, offset, capacity);
        this.resetFromTypedArray(other.data, other.offset + offset, capacity);
    }

    public final void resetFromTypedArray(ByteChunk<ATTR>[] data, int offset, int capacity) {
        ChunkHelpers.checkArrayArgs(data.length, offset, capacity);
        this.data = data;
        this.offset = offset;
        this.capacity = capacity;
        this.size = capacity;
    }
}

