/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.CharChunkChunk;
import io.deephaven.chunk.ChunkChunk;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.ResettableChunkChunk;
import io.deephaven.chunk.attributes.Any;

public class ResettableCharChunkChunk<ATTR extends Any>
extends CharChunkChunk<ATTR>
implements ResettableChunkChunk<ATTR> {
    public static <ATTR extends Any> ResettableCharChunkChunk<ATTR> makeResettableChunk() {
        return new ResettableCharChunkChunk<ATTR>();
    }

    private ResettableCharChunkChunk(CharChunk<ATTR>[] data, int offset, int capacity) {
        super(data, offset, capacity);
    }

    private ResettableCharChunkChunk() {
        this(CharChunk.getEmptyChunkArray(), 0, 0);
    }

    @Override
    public ResettableCharChunkChunk<ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new ResettableCharChunkChunk<ATTR>(this.data, this.offset + offset, capacity);
    }

    @Override
    public final void resetFromChunk(ChunkChunk<ATTR> other, int offset, int capacity) {
        this.resetFromTypedChunk(other.asCharChunkChunk(), offset, capacity);
    }

    @Override
    public final void resetFromArray(Object array, int offset, int capacity) {
        CharChunk[] typedArray = (CharChunk[])array;
        this.resetFromTypedArray(typedArray, offset, capacity);
    }

    public final void resetFromTypedChunk(CharChunkChunk<ATTR> other, int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(other.size, offset, capacity);
        this.resetFromTypedArray(other.data, other.offset + offset, capacity);
    }

    public final void resetFromTypedArray(CharChunk<ATTR>[] data, int offset, int capacity) {
        ChunkHelpers.checkArrayArgs(data.length, offset, capacity);
        this.data = data;
        this.offset = offset;
        this.capacity = capacity;
        this.size = capacity;
    }
}

