/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.ChunkChunk;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.DoubleChunkChunk;
import io.deephaven.chunk.ResettableChunkChunk;
import io.deephaven.chunk.attributes.Any;

public class ResettableDoubleChunkChunk<ATTR extends Any>
extends DoubleChunkChunk<ATTR>
implements ResettableChunkChunk<ATTR> {
    public static <ATTR extends Any> ResettableDoubleChunkChunk<ATTR> makeResettableChunk() {
        return new ResettableDoubleChunkChunk<ATTR>();
    }

    private ResettableDoubleChunkChunk(DoubleChunk<ATTR>[] data, int offset, int capacity) {
        super(data, offset, capacity);
    }

    private ResettableDoubleChunkChunk() {
        this(DoubleChunk.getEmptyChunkArray(), 0, 0);
    }

    @Override
    public ResettableDoubleChunkChunk<ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new ResettableDoubleChunkChunk<ATTR>(this.data, this.offset + offset, capacity);
    }

    @Override
    public final void resetFromChunk(ChunkChunk<ATTR> other, int offset, int capacity) {
        this.resetFromTypedChunk(other.asDoubleChunkChunk(), offset, capacity);
    }

    @Override
    public final void resetFromArray(Object array, int offset, int capacity) {
        DoubleChunk[] typedArray = (DoubleChunk[])array;
        this.resetFromTypedArray(typedArray, offset, capacity);
    }

    public final void resetFromTypedChunk(DoubleChunkChunk<ATTR> other, int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(other.size, offset, capacity);
        this.resetFromTypedArray(other.data, other.offset + offset, capacity);
    }

    public final void resetFromTypedArray(DoubleChunk<ATTR>[] data, int offset, int capacity) {
        ChunkHelpers.checkArrayArgs(data.length, offset, capacity);
        this.data = data;
        this.offset = offset;
        this.capacity = capacity;
        this.size = capacity;
    }
}

