/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.ChunkChunk;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.FloatChunk;
import io.deephaven.chunk.FloatChunkChunk;
import io.deephaven.chunk.ResettableChunkChunk;
import io.deephaven.chunk.attributes.Any;

public class ResettableFloatChunkChunk<ATTR extends Any>
extends FloatChunkChunk<ATTR>
implements ResettableChunkChunk<ATTR> {
    public static <ATTR extends Any> ResettableFloatChunkChunk<ATTR> makeResettableChunk() {
        return new ResettableFloatChunkChunk<ATTR>();
    }

    private ResettableFloatChunkChunk(FloatChunk<ATTR>[] data, int offset, int capacity) {
        super(data, offset, capacity);
    }

    private ResettableFloatChunkChunk() {
        this(FloatChunk.getEmptyChunkArray(), 0, 0);
    }

    @Override
    public ResettableFloatChunkChunk<ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new ResettableFloatChunkChunk<ATTR>(this.data, this.offset + offset, capacity);
    }

    @Override
    public final void resetFromChunk(ChunkChunk<ATTR> other, int offset, int capacity) {
        this.resetFromTypedChunk(other.asFloatChunkChunk(), offset, capacity);
    }

    @Override
    public final void resetFromArray(Object array, int offset, int capacity) {
        FloatChunk[] typedArray = (FloatChunk[])array;
        this.resetFromTypedArray(typedArray, offset, capacity);
    }

    public final void resetFromTypedChunk(FloatChunkChunk<ATTR> other, int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(other.size, offset, capacity);
        this.resetFromTypedArray(other.data, other.offset + offset, capacity);
    }

    public final void resetFromTypedArray(FloatChunk<ATTR>[] data, int offset, int capacity) {
        ChunkHelpers.checkArrayArgs(data.length, offset, capacity);
        this.data = data;
        this.offset = offset;
        this.capacity = capacity;
        this.size = capacity;
    }
}

