/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.ResettableReadOnlyChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.pools.MultiChunkPool;
import io.deephaven.util.type.ArrayTypeUtils;

public class ResettableIntChunk<ATTR_UPPER extends Any>
extends IntChunk<ATTR_UPPER>
implements ResettableReadOnlyChunk<ATTR_UPPER> {
    public static <ATTR_BASE extends Any> ResettableIntChunk<ATTR_BASE> makeResettableChunk() {
        return new ResettableIntChunk();
    }

    public static <ATTR_BASE extends Any> ResettableIntChunk<ATTR_BASE> makeResettableChunkForPool() {
        return new ResettableIntChunk<ATTR_BASE>(){

            @Override
            public void close() {
                MultiChunkPool.forThisThread().giveResettableIntChunk(this);
            }
        };
    }

    private ResettableIntChunk(int[] data, int offset, int capacity) {
        super(data, offset, capacity);
    }

    private ResettableIntChunk() {
        this(ArrayTypeUtils.EMPTY_INT_ARRAY, 0, 0);
    }

    @Override
    public ResettableIntChunk<ATTR_UPPER> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new ResettableIntChunk<ATTR_UPPER>(this.data, this.offset + offset, capacity);
    }

    @Override
    public <ATTR extends ATTR_UPPER> IntChunk<ATTR> resetFromChunk(Chunk<? extends ATTR> other, int offset, int capacity) {
        return this.resetFromTypedChunk(other.asIntChunk(), offset, capacity);
    }

    @Override
    public <ATTR extends ATTR_UPPER> IntChunk<ATTR> resetFromArray(Object array, int offset, int capacity) {
        int[] typedArray = (int[])array;
        return this.resetFromTypedArray(typedArray, offset, capacity);
    }

    @Override
    public <ATTR extends ATTR_UPPER> IntChunk<ATTR> resetFromArray(Object array) {
        int[] typedArray = (int[])array;
        return this.resetFromTypedArray(typedArray, 0, typedArray.length);
    }

    @Override
    public <ATTR extends ATTR_UPPER> IntChunk<ATTR> clear() {
        return this.resetFromArray(ArrayTypeUtils.EMPTY_INT_ARRAY, 0, 0);
    }

    public <ATTR extends ATTR_UPPER> IntChunk<ATTR> resetFromTypedChunk(IntChunk<? extends ATTR> other, int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(other.size, offset, capacity);
        return this.resetFromTypedArray(other.data, other.offset + offset, capacity);
    }

    public <ATTR extends ATTR_UPPER> IntChunk<ATTR> resetFromTypedArray(int[] data, int offset, int capacity) {
        ChunkHelpers.checkArrayArgs(data.length, offset, capacity);
        this.data = data;
        this.offset = offset;
        this.capacity = capacity;
        this.size = capacity;
        return IntChunk.downcast(this);
    }

    public void close() {
    }
}

