/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.ChunkChunk;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.IntChunkChunk;
import io.deephaven.chunk.ResettableChunkChunk;
import io.deephaven.chunk.attributes.Any;

public class ResettableIntChunkChunk<ATTR extends Any>
extends IntChunkChunk<ATTR>
implements ResettableChunkChunk<ATTR> {
    public static <ATTR extends Any> ResettableIntChunkChunk<ATTR> makeResettableChunk() {
        return new ResettableIntChunkChunk<ATTR>();
    }

    private ResettableIntChunkChunk(IntChunk<ATTR>[] data, int offset, int capacity) {
        super(data, offset, capacity);
    }

    private ResettableIntChunkChunk() {
        this(IntChunk.getEmptyChunkArray(), 0, 0);
    }

    @Override
    public ResettableIntChunkChunk<ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new ResettableIntChunkChunk<ATTR>(this.data, this.offset + offset, capacity);
    }

    @Override
    public final void resetFromChunk(ChunkChunk<ATTR> other, int offset, int capacity) {
        this.resetFromTypedChunk(other.asIntChunkChunk(), offset, capacity);
    }

    @Override
    public final void resetFromArray(Object array, int offset, int capacity) {
        IntChunk[] typedArray = (IntChunk[])array;
        this.resetFromTypedArray(typedArray, offset, capacity);
    }

    public final void resetFromTypedChunk(IntChunkChunk<ATTR> other, int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(other.size, offset, capacity);
        this.resetFromTypedArray(other.data, other.offset + offset, capacity);
    }

    public final void resetFromTypedArray(IntChunk<ATTR>[] data, int offset, int capacity) {
        ChunkHelpers.checkArrayArgs(data.length, offset, capacity);
        this.data = data;
        this.offset = offset;
        this.capacity = capacity;
        this.size = capacity;
    }
}

