/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.ResettableReadOnlyChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.pools.MultiChunkPool;
import io.deephaven.util.type.ArrayTypeUtils;

public class ResettableLongChunk<ATTR_UPPER extends Any>
extends LongChunk<ATTR_UPPER>
implements ResettableReadOnlyChunk<ATTR_UPPER> {
    public static <ATTR_BASE extends Any> ResettableLongChunk<ATTR_BASE> makeResettableChunk() {
        return new ResettableLongChunk();
    }

    public static <ATTR_BASE extends Any> ResettableLongChunk<ATTR_BASE> makeResettableChunkForPool() {
        return new ResettableLongChunk<ATTR_BASE>(){

            @Override
            public void close() {
                MultiChunkPool.forThisThread().giveResettableLongChunk(this);
            }
        };
    }

    private ResettableLongChunk(long[] data, int offset, int capacity) {
        super(data, offset, capacity);
    }

    private ResettableLongChunk() {
        this(ArrayTypeUtils.EMPTY_LONG_ARRAY, 0, 0);
    }

    @Override
    public ResettableLongChunk<ATTR_UPPER> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new ResettableLongChunk<ATTR_UPPER>(this.data, this.offset + offset, capacity);
    }

    @Override
    public <ATTR extends ATTR_UPPER> LongChunk<ATTR> resetFromChunk(Chunk<? extends ATTR> other, int offset, int capacity) {
        return this.resetFromTypedChunk(other.asLongChunk(), offset, capacity);
    }

    @Override
    public <ATTR extends ATTR_UPPER> LongChunk<ATTR> resetFromArray(Object array, int offset, int capacity) {
        long[] typedArray = (long[])array;
        return this.resetFromTypedArray(typedArray, offset, capacity);
    }

    @Override
    public <ATTR extends ATTR_UPPER> LongChunk<ATTR> resetFromArray(Object array) {
        long[] typedArray = (long[])array;
        return this.resetFromTypedArray(typedArray, 0, typedArray.length);
    }

    @Override
    public <ATTR extends ATTR_UPPER> LongChunk<ATTR> clear() {
        return this.resetFromArray(ArrayTypeUtils.EMPTY_LONG_ARRAY, 0, 0);
    }

    public <ATTR extends ATTR_UPPER> LongChunk<ATTR> resetFromTypedChunk(LongChunk<? extends ATTR> other, int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(other.size, offset, capacity);
        return this.resetFromTypedArray(other.data, other.offset + offset, capacity);
    }

    public <ATTR extends ATTR_UPPER> LongChunk<ATTR> resetFromTypedArray(long[] data, int offset, int capacity) {
        ChunkHelpers.checkArrayArgs(data.length, offset, capacity);
        this.data = data;
        this.offset = offset;
        this.capacity = capacity;
        this.size = capacity;
        return LongChunk.downcast(this);
    }

    public void close() {
    }
}

