/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.ResettableReadOnlyChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.pools.MultiChunkPool;
import io.deephaven.util.type.ArrayTypeUtils;

public class ResettableObjectChunk<T, ATTR_UPPER extends Any>
extends ObjectChunk<T, ATTR_UPPER>
implements ResettableReadOnlyChunk<ATTR_UPPER> {
    public static <T, ATTR_BASE extends Any> ResettableObjectChunk<T, ATTR_BASE> makeResettableChunk() {
        return new ResettableObjectChunk();
    }

    public static <T, ATTR_BASE extends Any> ResettableObjectChunk<T, ATTR_BASE> makeResettableChunkForPool() {
        return new ResettableObjectChunk<T, ATTR_BASE>(){

            @Override
            public void close() {
                MultiChunkPool.forThisThread().giveResettableObjectChunk(this);
            }
        };
    }

    private ResettableObjectChunk(T[] data, int offset, int capacity) {
        super(data, offset, capacity);
    }

    private ResettableObjectChunk() {
        this(ArrayTypeUtils.EMPTY_OBJECT_ARRAY, 0, 0);
    }

    @Override
    public ResettableObjectChunk<T, ATTR_UPPER> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new ResettableObjectChunk<Object, ATTR_UPPER>(this.data, this.offset + offset, capacity);
    }

    public <ATTR extends ATTR_UPPER> ObjectChunk<T, ATTR> resetFromChunk(Chunk<? extends ATTR> other, int offset, int capacity) {
        return this.resetFromTypedChunk(other.asObjectChunk(), offset, capacity);
    }

    public <ATTR extends ATTR_UPPER> ObjectChunk<T, ATTR> resetFromArray(Object array, int offset, int capacity) {
        Object[] typedArray = (Object[])array;
        return this.resetFromTypedArray(typedArray, offset, capacity);
    }

    public <ATTR extends ATTR_UPPER> ObjectChunk<T, ATTR> resetFromArray(Object array) {
        Object[] typedArray = (Object[])array;
        return this.resetFromTypedArray(typedArray, 0, typedArray.length);
    }

    public <ATTR extends ATTR_UPPER> ObjectChunk<T, ATTR> clear() {
        return this.resetFromArray(ArrayTypeUtils.EMPTY_OBJECT_ARRAY, 0, 0);
    }

    public <ATTR extends ATTR_UPPER> ObjectChunk<T, ATTR> resetFromTypedChunk(ObjectChunk<T, ? extends ATTR> other, int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(other.size, offset, capacity);
        return this.resetFromTypedArray(other.data, other.offset + offset, capacity);
    }

    public <ATTR extends ATTR_UPPER> ObjectChunk<T, ATTR> resetFromTypedArray(T[] data, int offset, int capacity) {
        ChunkHelpers.checkArrayArgs(data.length, offset, capacity);
        this.data = data;
        this.offset = offset;
        this.capacity = capacity;
        this.size = capacity;
        return ObjectChunk.downcast(this);
    }

    public void close() {
    }
}

