/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.ChunkChunk;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.ObjectChunkChunk;
import io.deephaven.chunk.ResettableChunkChunk;
import io.deephaven.chunk.attributes.Any;

public class ResettableObjectChunkChunk<T, ATTR extends Any>
extends ObjectChunkChunk<T, ATTR>
implements ResettableChunkChunk<ATTR> {
    public static <T, ATTR extends Any> ResettableObjectChunkChunk<T, ATTR> makeResettableChunk() {
        return new ResettableObjectChunkChunk<T, ATTR>();
    }

    private ResettableObjectChunkChunk(ObjectChunk<T, ATTR>[] data, int offset, int capacity) {
        super(data, offset, capacity);
    }

    private ResettableObjectChunkChunk() {
        this(ObjectChunk.getEmptyChunkArray(), 0, 0);
    }

    @Override
    public ResettableObjectChunkChunk<T, ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new ResettableObjectChunkChunk<T, ATTR>(this.data, this.offset + offset, capacity);
    }

    @Override
    public final void resetFromChunk(ChunkChunk<ATTR> other, int offset, int capacity) {
        this.resetFromTypedChunk(other.asObjectChunkChunk(), offset, capacity);
    }

    @Override
    public final void resetFromArray(Object array, int offset, int capacity) {
        ObjectChunk[] typedArray = (ObjectChunk[])array;
        this.resetFromTypedArray(typedArray, offset, capacity);
    }

    public final void resetFromTypedChunk(ObjectChunkChunk<T, ATTR> other, int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(other.size, offset, capacity);
        this.resetFromTypedArray(other.data, other.offset + offset, capacity);
    }

    public final void resetFromTypedArray(ObjectChunk<T, ATTR>[] data, int offset, int capacity) {
        ChunkHelpers.checkArrayArgs(data.length, offset, capacity);
        this.data = data;
        this.offset = offset;
        this.capacity = capacity;
        this.size = capacity;
    }
}

