/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.ResettableWritableChunk;
import io.deephaven.chunk.WritableBooleanChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.pools.MultiChunkPool;
import io.deephaven.util.type.ArrayTypeUtils;

public class ResettableWritableBooleanChunk<ATTR_BASE extends Any>
extends WritableBooleanChunk<ATTR_BASE>
implements ResettableWritableChunk<ATTR_BASE> {
    public static <ATTR_BASE extends Any> ResettableWritableBooleanChunk<ATTR_BASE> makeResettableChunk() {
        return new ResettableWritableBooleanChunk<ATTR_BASE>();
    }

    public static <ATTR_BASE extends Any> ResettableWritableBooleanChunk<ATTR_BASE> makeResettableChunkForPool() {
        return new ResettableWritableBooleanChunk<ATTR_BASE>(){

            @Override
            public void close() {
                MultiChunkPool.forThisThread().giveResettableWritableBooleanChunk(this);
            }
        };
    }

    private ResettableWritableBooleanChunk(boolean[] data, int offset, int capacity) {
        super(data, offset, capacity);
    }

    private ResettableWritableBooleanChunk() {
        this(ArrayTypeUtils.EMPTY_BOOLEAN_ARRAY, 0, 0);
    }

    @Override
    public ResettableWritableBooleanChunk<ATTR_BASE> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new ResettableWritableBooleanChunk<ATTR_BASE>(this.data, this.offset + offset, capacity);
    }

    @Override
    public <ATTR extends ATTR_BASE> WritableBooleanChunk<ATTR> resetFromChunk(WritableChunk<ATTR> other, int offset, int capacity) {
        return this.resetFromTypedChunk(other.asWritableBooleanChunk(), offset, capacity);
    }

    @Override
    public <ATTR extends ATTR_BASE> WritableBooleanChunk<ATTR> resetFromArray(Object array, int offset, int capacity) {
        boolean[] typedArray = (boolean[])array;
        return this.resetFromTypedArray(typedArray, offset, capacity);
    }

    @Override
    public <ATTR extends ATTR_BASE> WritableBooleanChunk<ATTR> resetFromArray(Object array) {
        boolean[] typedArray = (boolean[])array;
        return this.resetFromTypedArray(typedArray, 0, typedArray.length);
    }

    @Override
    public <ATTR extends ATTR_BASE> WritableBooleanChunk<ATTR> clear() {
        return this.resetFromArray(ArrayTypeUtils.EMPTY_BOOLEAN_ARRAY, 0, 0);
    }

    public <ATTR extends ATTR_BASE> WritableBooleanChunk<ATTR> resetFromTypedChunk(WritableBooleanChunk<ATTR> other, int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(other.size, offset, capacity);
        return this.resetFromTypedArray(other.data, other.offset + offset, capacity);
    }

    public <ATTR extends ATTR_BASE> WritableBooleanChunk<ATTR> resetFromTypedArray(boolean[] data, int offset, int capacity) {
        ChunkHelpers.checkArrayArgs(data.length, offset, capacity);
        this.data = data;
        this.offset = offset;
        this.capacity = capacity;
        this.size = capacity;
        return this;
    }
}

