/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.ResettableWritableChunk;
import io.deephaven.chunk.WritableByteChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.pools.MultiChunkPool;
import io.deephaven.util.type.ArrayTypeUtils;

public class ResettableWritableByteChunk<ATTR_BASE extends Any>
extends WritableByteChunk<ATTR_BASE>
implements ResettableWritableChunk<ATTR_BASE> {
    public static <ATTR_BASE extends Any> ResettableWritableByteChunk<ATTR_BASE> makeResettableChunk() {
        return new ResettableWritableByteChunk<ATTR_BASE>();
    }

    public static <ATTR_BASE extends Any> ResettableWritableByteChunk<ATTR_BASE> makeResettableChunkForPool() {
        return new ResettableWritableByteChunk<ATTR_BASE>(){

            @Override
            public void close() {
                MultiChunkPool.forThisThread().giveResettableWritableByteChunk(this);
            }
        };
    }

    private ResettableWritableByteChunk(byte[] data, int offset, int capacity) {
        super(data, offset, capacity);
    }

    private ResettableWritableByteChunk() {
        this(ArrayTypeUtils.EMPTY_BYTE_ARRAY, 0, 0);
    }

    @Override
    public ResettableWritableByteChunk<ATTR_BASE> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new ResettableWritableByteChunk<ATTR_BASE>(this.data, this.offset + offset, capacity);
    }

    @Override
    public <ATTR extends ATTR_BASE> WritableByteChunk<ATTR> resetFromChunk(WritableChunk<ATTR> other, int offset, int capacity) {
        return this.resetFromTypedChunk(other.asWritableByteChunk(), offset, capacity);
    }

    @Override
    public <ATTR extends ATTR_BASE> WritableByteChunk<ATTR> resetFromArray(Object array, int offset, int capacity) {
        byte[] typedArray = (byte[])array;
        return this.resetFromTypedArray(typedArray, offset, capacity);
    }

    @Override
    public <ATTR extends ATTR_BASE> WritableByteChunk<ATTR> resetFromArray(Object array) {
        byte[] typedArray = (byte[])array;
        return this.resetFromTypedArray(typedArray, 0, typedArray.length);
    }

    @Override
    public <ATTR extends ATTR_BASE> WritableByteChunk<ATTR> clear() {
        return this.resetFromArray(ArrayTypeUtils.EMPTY_BYTE_ARRAY, 0, 0);
    }

    public <ATTR extends ATTR_BASE> WritableByteChunk<ATTR> resetFromTypedChunk(WritableByteChunk<ATTR> other, int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(other.size, offset, capacity);
        return this.resetFromTypedArray(other.data, other.offset + offset, capacity);
    }

    public <ATTR extends ATTR_BASE> WritableByteChunk<ATTR> resetFromTypedArray(byte[] data, int offset, int capacity) {
        ChunkHelpers.checkArrayArgs(data.length, offset, capacity);
        this.data = data;
        this.offset = offset;
        this.capacity = capacity;
        this.size = capacity;
        return this;
    }
}

