/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.ResettableWritableChunkChunk;
import io.deephaven.chunk.WritableByteChunk;
import io.deephaven.chunk.WritableByteChunkChunk;
import io.deephaven.chunk.WritableChunkChunk;
import io.deephaven.chunk.attributes.Any;

public class ResettableWritableByteChunkChunk<ATTR extends Any>
extends WritableByteChunkChunk<ATTR>
implements ResettableWritableChunkChunk<ATTR> {
    public static <ATTR extends Any> ResettableWritableByteChunkChunk<ATTR> makeResettableChunk() {
        return new ResettableWritableByteChunkChunk<ATTR>();
    }

    private ResettableWritableByteChunkChunk(WritableByteChunk<ATTR>[] data, int offset, int capacity) {
        super(data, offset, capacity);
    }

    private ResettableWritableByteChunkChunk() {
        this(WritableByteChunk.getEmptyChunkArray(), 0, 0);
    }

    @Override
    public ResettableWritableByteChunkChunk<ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new ResettableWritableByteChunkChunk<ATTR>(this.writableData, this.offset + offset, capacity);
    }

    @Override
    public final void resetFromChunk(WritableChunkChunk<ATTR> other, int offset, int capacity) {
        this.resetFromTypedChunk(other.asWritableByteChunkChunk(), offset, capacity);
    }

    @Override
    public final void resetFromArray(Object array, int offset, int capacity) {
        WritableByteChunk[] typedArray = (WritableByteChunk[])array;
        this.resetFromTypedArray(typedArray, offset, capacity);
    }

    public final void resetFromTypedChunk(WritableByteChunkChunk<ATTR> other, int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(other.size, offset, capacity);
        this.resetFromTypedArray(other.writableData, other.offset + offset, capacity);
    }

    public final void resetFromTypedArray(WritableByteChunk<ATTR>[] data, int offset, int capacity) {
        ChunkHelpers.checkArrayArgs(data.length, offset, capacity);
        int oldCapacity = this.capacity;
        this.data = data;
        this.writableData = data;
        this.offset = offset;
        this.capacity = capacity;
        this.size = capacity;
        this.resetInnerCache(data, offset, oldCapacity, capacity);
    }
}

