/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.ResettableWritableChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableFloatChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.pools.MultiChunkPool;
import io.deephaven.util.type.ArrayTypeUtils;

public class ResettableWritableFloatChunk<ATTR_BASE extends Any>
extends WritableFloatChunk<ATTR_BASE>
implements ResettableWritableChunk<ATTR_BASE> {
    public static <ATTR_BASE extends Any> ResettableWritableFloatChunk<ATTR_BASE> makeResettableChunk() {
        return new ResettableWritableFloatChunk<ATTR_BASE>();
    }

    public static <ATTR_BASE extends Any> ResettableWritableFloatChunk<ATTR_BASE> makeResettableChunkForPool() {
        return new ResettableWritableFloatChunk<ATTR_BASE>(){

            @Override
            public void close() {
                MultiChunkPool.forThisThread().giveResettableWritableFloatChunk(this);
            }
        };
    }

    private ResettableWritableFloatChunk(float[] data, int offset, int capacity) {
        super(data, offset, capacity);
    }

    private ResettableWritableFloatChunk() {
        this(ArrayTypeUtils.EMPTY_FLOAT_ARRAY, 0, 0);
    }

    @Override
    public ResettableWritableFloatChunk<ATTR_BASE> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new ResettableWritableFloatChunk<ATTR_BASE>(this.data, this.offset + offset, capacity);
    }

    @Override
    public <ATTR extends ATTR_BASE> WritableFloatChunk<ATTR> resetFromChunk(WritableChunk<ATTR> other, int offset, int capacity) {
        return this.resetFromTypedChunk(other.asWritableFloatChunk(), offset, capacity);
    }

    @Override
    public <ATTR extends ATTR_BASE> WritableFloatChunk<ATTR> resetFromArray(Object array, int offset, int capacity) {
        float[] typedArray = (float[])array;
        return this.resetFromTypedArray(typedArray, offset, capacity);
    }

    @Override
    public <ATTR extends ATTR_BASE> WritableFloatChunk<ATTR> resetFromArray(Object array) {
        float[] typedArray = (float[])array;
        return this.resetFromTypedArray(typedArray, 0, typedArray.length);
    }

    @Override
    public <ATTR extends ATTR_BASE> WritableFloatChunk<ATTR> clear() {
        return this.resetFromArray(ArrayTypeUtils.EMPTY_FLOAT_ARRAY, 0, 0);
    }

    public <ATTR extends ATTR_BASE> WritableFloatChunk<ATTR> resetFromTypedChunk(WritableFloatChunk<ATTR> other, int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(other.size, offset, capacity);
        return this.resetFromTypedArray(other.data, other.offset + offset, capacity);
    }

    public <ATTR extends ATTR_BASE> WritableFloatChunk<ATTR> resetFromTypedArray(float[] data, int offset, int capacity) {
        ChunkHelpers.checkArrayArgs(data.length, offset, capacity);
        this.data = data;
        this.offset = offset;
        this.capacity = capacity;
        this.size = capacity;
        return this;
    }
}

