/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.ResettableWritableChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.pools.MultiChunkPool;
import io.deephaven.util.type.ArrayTypeUtils;

public class ResettableWritableIntChunk<ATTR_BASE extends Any>
extends WritableIntChunk<ATTR_BASE>
implements ResettableWritableChunk<ATTR_BASE> {
    public static <ATTR_BASE extends Any> ResettableWritableIntChunk<ATTR_BASE> makeResettableChunk() {
        return new ResettableWritableIntChunk<ATTR_BASE>();
    }

    public static <ATTR_BASE extends Any> ResettableWritableIntChunk<ATTR_BASE> makeResettableChunkForPool() {
        return new ResettableWritableIntChunk<ATTR_BASE>(){

            @Override
            public void close() {
                MultiChunkPool.forThisThread().giveResettableWritableIntChunk(this);
            }
        };
    }

    private ResettableWritableIntChunk(int[] data, int offset, int capacity) {
        super(data, offset, capacity);
    }

    private ResettableWritableIntChunk() {
        this(ArrayTypeUtils.EMPTY_INT_ARRAY, 0, 0);
    }

    @Override
    public ResettableWritableIntChunk<ATTR_BASE> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new ResettableWritableIntChunk<ATTR_BASE>(this.data, this.offset + offset, capacity);
    }

    @Override
    public <ATTR extends ATTR_BASE> WritableIntChunk<ATTR> resetFromChunk(WritableChunk<ATTR> other, int offset, int capacity) {
        return this.resetFromTypedChunk(other.asWritableIntChunk(), offset, capacity);
    }

    @Override
    public <ATTR extends ATTR_BASE> WritableIntChunk<ATTR> resetFromArray(Object array, int offset, int capacity) {
        int[] typedArray = (int[])array;
        return this.resetFromTypedArray(typedArray, offset, capacity);
    }

    @Override
    public <ATTR extends ATTR_BASE> WritableIntChunk<ATTR> resetFromArray(Object array) {
        int[] typedArray = (int[])array;
        return this.resetFromTypedArray(typedArray, 0, typedArray.length);
    }

    @Override
    public <ATTR extends ATTR_BASE> WritableIntChunk<ATTR> clear() {
        return this.resetFromArray(ArrayTypeUtils.EMPTY_INT_ARRAY, 0, 0);
    }

    public <ATTR extends ATTR_BASE> WritableIntChunk<ATTR> resetFromTypedChunk(WritableIntChunk<ATTR> other, int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(other.size, offset, capacity);
        return this.resetFromTypedArray(other.data, other.offset + offset, capacity);
    }

    public <ATTR extends ATTR_BASE> WritableIntChunk<ATTR> resetFromTypedArray(int[] data, int offset, int capacity) {
        ChunkHelpers.checkArrayArgs(data.length, offset, capacity);
        this.data = data;
        this.offset = offset;
        this.capacity = capacity;
        this.size = capacity;
        return this;
    }
}

