/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.ResettableWritableChunkChunk;
import io.deephaven.chunk.WritableChunkChunk;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.WritableIntChunkChunk;
import io.deephaven.chunk.attributes.Any;

public class ResettableWritableIntChunkChunk<ATTR extends Any>
extends WritableIntChunkChunk<ATTR>
implements ResettableWritableChunkChunk<ATTR> {
    public static <ATTR extends Any> ResettableWritableIntChunkChunk<ATTR> makeResettableChunk() {
        return new ResettableWritableIntChunkChunk<ATTR>();
    }

    private ResettableWritableIntChunkChunk(WritableIntChunk<ATTR>[] data, int offset, int capacity) {
        super(data, offset, capacity);
    }

    private ResettableWritableIntChunkChunk() {
        this(WritableIntChunk.getEmptyChunkArray(), 0, 0);
    }

    @Override
    public ResettableWritableIntChunkChunk<ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new ResettableWritableIntChunkChunk<ATTR>(this.writableData, this.offset + offset, capacity);
    }

    @Override
    public final void resetFromChunk(WritableChunkChunk<ATTR> other, int offset, int capacity) {
        this.resetFromTypedChunk(other.asWritableIntChunkChunk(), offset, capacity);
    }

    @Override
    public final void resetFromArray(Object array, int offset, int capacity) {
        WritableIntChunk[] typedArray = (WritableIntChunk[])array;
        this.resetFromTypedArray(typedArray, offset, capacity);
    }

    public final void resetFromTypedChunk(WritableIntChunkChunk<ATTR> other, int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(other.size, offset, capacity);
        this.resetFromTypedArray(other.writableData, other.offset + offset, capacity);
    }

    public final void resetFromTypedArray(WritableIntChunk<ATTR>[] data, int offset, int capacity) {
        ChunkHelpers.checkArrayArgs(data.length, offset, capacity);
        int oldCapacity = this.capacity;
        this.data = data;
        this.writableData = data;
        this.offset = offset;
        this.capacity = capacity;
        this.size = capacity;
        this.resetInnerCache(data, offset, oldCapacity, capacity);
    }
}

