/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.ResettableWritableChunkChunk;
import io.deephaven.chunk.WritableChunkChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.WritableObjectChunkChunk;
import io.deephaven.chunk.attributes.Any;

public class ResettableWritableObjectChunkChunk<T, ATTR extends Any>
extends WritableObjectChunkChunk<T, ATTR>
implements ResettableWritableChunkChunk<ATTR> {
    public static <T, ATTR extends Any> ResettableWritableObjectChunkChunk<T, ATTR> makeResettableChunk() {
        return new ResettableWritableObjectChunkChunk<T, ATTR>();
    }

    private ResettableWritableObjectChunkChunk(WritableObjectChunk<T, ATTR>[] data, int offset, int capacity) {
        super(data, offset, capacity);
    }

    private ResettableWritableObjectChunkChunk() {
        this(WritableObjectChunk.getEmptyChunkArray(), 0, 0);
    }

    @Override
    public ResettableWritableObjectChunkChunk<T, ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new ResettableWritableObjectChunkChunk<T, ATTR>(this.writableData, this.offset + offset, capacity);
    }

    @Override
    public final void resetFromChunk(WritableChunkChunk<ATTR> other, int offset, int capacity) {
        this.resetFromTypedChunk(other.asWritableObjectChunkChunk(), offset, capacity);
    }

    @Override
    public final void resetFromArray(Object array, int offset, int capacity) {
        WritableObjectChunk[] typedArray = (WritableObjectChunk[])array;
        this.resetFromTypedArray(typedArray, offset, capacity);
    }

    public final void resetFromTypedChunk(WritableObjectChunkChunk<T, ATTR> other, int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(other.size, offset, capacity);
        this.resetFromTypedArray(other.writableData, other.offset + offset, capacity);
    }

    public final void resetFromTypedArray(WritableObjectChunk<T, ATTR>[] data, int offset, int capacity) {
        ChunkHelpers.checkArrayArgs(data.length, offset, capacity);
        int oldCapacity = this.capacity;
        this.data = data;
        this.writableData = data;
        this.offset = offset;
        this.capacity = capacity;
        this.size = capacity;
        this.resetInnerCache(data, offset, oldCapacity, capacity);
    }
}

