/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.ChunkChunk;
import io.deephaven.chunk.ChunkChunkBase;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.attributes.Any;

public class ShortChunkChunk<ATTR extends Any>
extends ChunkChunkBase<ATTR>
implements ChunkChunk<ATTR> {
    private static final ShortChunkChunk EMPTY = new ShortChunkChunk(new ShortChunk[0], 0, 0);
    ShortChunk<ATTR>[] data;
    short[][] innerData;
    int[] innerOffsets;

    public static <ATTR extends Any> ShortChunkChunk<ATTR> getEmptyChunk() {
        return EMPTY;
    }

    public static <ATTR extends Any> ShortChunk<ATTR>[] makeArray(int capacity) {
        return new ShortChunk[capacity];
    }

    public static <ATTR extends Any> ShortChunkChunk<ATTR> chunkWrap(ShortChunk<ATTR>[] data) {
        return new ShortChunkChunk<ATTR>(data, 0, data.length);
    }

    public static <ATTR extends Any> ShortChunkChunk<ATTR> chunkWrap(ShortChunk<ATTR>[] data, int offset, int capacity) {
        return new ShortChunkChunk<ATTR>(data, offset, capacity);
    }

    ShortChunkChunk(ShortChunk<ATTR>[] data, int offset, int capacity) {
        super(data.length, offset, capacity);
        this.data = data;
        this.resetInnerCache(data, offset, 0, capacity);
    }

    final void resetInnerCache(ShortChunk<ATTR>[] data, int offset, int oldCapacity, int newCapacity) {
        int ii;
        if (this.innerData == null || this.innerData.length < newCapacity) {
            this.innerData = new short[newCapacity][];
            this.innerOffsets = new int[newCapacity];
        }
        for (ii = 0; ii < newCapacity; ++ii) {
            this.resetInnerCacheItem(ii, data[ii + offset]);
        }
        for (ii = newCapacity; ii < oldCapacity; ++ii) {
            this.innerData[ii] = null;
            this.innerOffsets[ii] = 0;
        }
    }

    final void resetInnerCacheItem(int index, ShortChunk<ATTR> chunk) {
        if (chunk == null) {
            this.innerData[index] = null;
            this.innerOffsets[index] = 0;
        } else {
            this.innerData[index] = chunk.data;
            this.innerOffsets[index] = chunk.offset;
        }
    }

    public final ShortChunk<ATTR> get(int index) {
        return this.data[this.offset + index];
    }

    @Override
    public final ShortChunk<ATTR> getChunk(int index) {
        return this.get(index);
    }

    public final short get(int j, int i) {
        return this.innerData[j][this.innerOffsets[j] + i];
    }

    @Override
    public ShortChunkChunk<ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new ShortChunkChunk<ATTR>(this.data, this.offset + offset, capacity);
    }
}

