/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.BooleanChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.pools.MultiChunkPool;
import io.deephaven.util.type.TypeUtils;
import java.util.Arrays;

public class WritableBooleanChunk<ATTR extends Any>
extends BooleanChunk<ATTR>
implements WritableChunk<ATTR> {
    private static final WritableBooleanChunk[] EMPTY_WRITABLE_BOOLEAN_CHUNK_ARRAY = new WritableBooleanChunk[0];

    static <ATTR extends Any> WritableBooleanChunk<ATTR>[] getEmptyChunkArray() {
        return EMPTY_WRITABLE_BOOLEAN_CHUNK_ARRAY;
    }

    public static <ATTR extends Any> WritableBooleanChunk<ATTR> makeWritableChunk(int size) {
        return MultiChunkPool.forThisThread().takeWritableBooleanChunk(size);
    }

    public static <ATTR extends Any> WritableBooleanChunk<ATTR> makeWritableChunkForPool(int size) {
        return new WritableBooleanChunk<ATTR>(WritableBooleanChunk.makeArray(size), 0, size){

            @Override
            public void close() {
                MultiChunkPool.forThisThread().giveWritableBooleanChunk(this);
            }
        };
    }

    public static <ATTR extends Any> WritableBooleanChunk<ATTR> writableChunkWrap(boolean[] data) {
        return WritableBooleanChunk.writableChunkWrap(data, 0, data.length);
    }

    public static <ATTR extends Any> WritableBooleanChunk<ATTR> writableChunkWrap(boolean[] data, int offset, int size) {
        return new WritableBooleanChunk<ATTR>(data, offset, size);
    }

    protected WritableBooleanChunk(boolean[] data, int offset, int capacity) {
        super(data, offset, capacity);
    }

    public final void set(int index, boolean value) {
        this.data[this.offset + index] = value;
    }

    public final void add(boolean value) {
        this.data[this.offset + this.size++] = value;
    }

    @Override
    public WritableBooleanChunk<ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new WritableBooleanChunk<ATTR>(this.data, this.offset + offset, capacity);
    }

    public final boolean[] array() {
        return this.data;
    }

    public final int arrayOffset() {
        return this.offset;
    }

    @Override
    public final void fillWithBoxedValue(int offset, int size, Object value) {
        this.fillWithValue(offset, size, TypeUtils.unbox((Boolean)((Boolean)value)));
    }

    public final void fillWithValue(int offset, int length, boolean value) {
        int netOffset = this.offset + offset;
        if (length >= 16) {
            Arrays.fill(this.data, netOffset, netOffset + length, value);
            return;
        }
        for (int ii = 0; ii < length; ++ii) {
            this.data[netOffset + ii] = value;
        }
    }

    public final void appendTypedChunk(BooleanChunk<? extends ATTR> src, int srcOffset, int length) {
        this.copyFromTypedChunk(src, srcOffset, this.size, length);
        this.size += length;
    }

    @Override
    public final void copyFromChunk(Chunk<? extends ATTR> src, int srcOffset, int destOffset, int length) {
        BooleanChunk<? extends ATTR> typedSrc = src.asBooleanChunk();
        this.copyFromTypedChunk(typedSrc, srcOffset, destOffset, length);
    }

    public final void copyFromTypedChunk(BooleanChunk<? extends ATTR> src, int srcOffset, int destOffset, int length) {
        this.copyFromTypedArray(src.data, src.offset + srcOffset, destOffset, length);
    }

    @Override
    public final void copyFromArray(Object srcArray, int srcOffset, int destOffset, int length) {
        boolean[] typedArray = (boolean[])srcArray;
        this.copyFromTypedArray(typedArray, srcOffset, destOffset, length);
    }

    public final void copyFromTypedArray(boolean[] src, int srcOffset, int destOffset, int length) {
        int netDestOffset = this.offset + destOffset;
        if (length >= 16) {
            System.arraycopy(src, srcOffset, this.data, netDestOffset, length);
            return;
        }
        if (ChunkHelpers.canCopyForward(src, srcOffset, this.data, destOffset, length)) {
            for (int ii = 0; ii < length; ++ii) {
                this.data[netDestOffset + ii] = src[srcOffset + ii];
            }
            return;
        }
        for (int ii = length - 1; ii >= 0; --ii) {
            this.data[netDestOffset + ii] = src[srcOffset + ii];
        }
    }

    @Override
    public final void sort() {
        this.sort(0, this.size);
    }

    public void close() {
    }

    public static <ATTR extends Any, ATTR_DERIV extends ATTR> WritableBooleanChunk<ATTR> upcast(WritableBooleanChunk<ATTR_DERIV> self) {
        return self;
    }
}

