/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.ByteChunkChunk;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.WritableByteChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableChunkChunk;
import io.deephaven.chunk.attributes.Any;

public class WritableByteChunkChunk<ATTR extends Any>
extends ByteChunkChunk<ATTR>
implements WritableChunkChunk<ATTR> {
    WritableByteChunk<ATTR>[] writableData;

    public static <ATTR extends Any> WritableByteChunk<ATTR>[] makeArray(int capacity) {
        return new WritableByteChunk[capacity];
    }

    public static <ATTR extends Any> WritableByteChunkChunk<ATTR> makeWritableChunk(int size) {
        return WritableByteChunkChunk.writableChunkWrap(WritableByteChunkChunk.makeArray(size), 0, size);
    }

    public static <ATTR extends Any> WritableByteChunkChunk<ATTR> writableChunkWrap(WritableByteChunk<ATTR>[] data) {
        return new WritableByteChunkChunk<ATTR>(data, 0, data.length);
    }

    public static <ATTR extends Any> WritableByteChunkChunk<ATTR> writableChunkWrap(WritableByteChunk<ATTR>[] data, int offset, int size) {
        return new WritableByteChunkChunk<ATTR>(data, offset, size);
    }

    WritableByteChunkChunk(WritableByteChunk<ATTR>[] data, int offset, int capacity) {
        super(data, offset, capacity);
        this.writableData = data;
    }

    public final void set(int index, WritableByteChunk<ATTR> value) {
        this.data[this.offset + index] = value;
        this.resetInnerCacheItem(index, value);
    }

    @Override
    public final WritableByteChunk<ATTR> getWritableChunk(int pos) {
        return this.writableData[this.offset + pos];
    }

    @Override
    public final void setWritableChunk(int pos, WritableChunk<ATTR> value) {
        this.set(pos, value.asWritableByteChunk());
    }

    public final void set(int j, int i, byte value) {
        this.innerData[j][this.innerOffsets[j] + i] = value;
    }

    @Override
    public WritableByteChunkChunk<ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new WritableByteChunkChunk<ATTR>(this.writableData, this.offset + offset, capacity);
    }
}

