/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.pools.MultiChunkPool;
import io.deephaven.util.type.TypeUtils;
import java.nio.Buffer;
import java.nio.CharBuffer;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class WritableCharChunk<ATTR extends Any>
extends CharChunk<ATTR>
implements WritableChunk<ATTR> {
    private static final WritableCharChunk[] EMPTY_WRITABLE_CHAR_CHUNK_ARRAY = new WritableCharChunk[0];

    static <ATTR extends Any> WritableCharChunk<ATTR>[] getEmptyChunkArray() {
        return EMPTY_WRITABLE_CHAR_CHUNK_ARRAY;
    }

    public static <ATTR extends Any> WritableCharChunk<ATTR> makeWritableChunk(int size) {
        return MultiChunkPool.forThisThread().takeWritableCharChunk(size);
    }

    public static <ATTR extends Any> WritableCharChunk<ATTR> makeWritableChunkForPool(int size) {
        return new WritableCharChunk<ATTR>(WritableCharChunk.makeArray(size), 0, size){

            @Override
            public void close() {
                MultiChunkPool.forThisThread().giveWritableCharChunk(this);
            }
        };
    }

    public static <ATTR extends Any> WritableCharChunk<ATTR> writableChunkWrap(char[] data) {
        return WritableCharChunk.writableChunkWrap(data, 0, data.length);
    }

    public static <ATTR extends Any> WritableCharChunk<ATTR> writableChunkWrap(char[] data, int offset, int size) {
        return new WritableCharChunk<ATTR>(data, offset, size);
    }

    protected WritableCharChunk(char[] data, int offset, int capacity) {
        super(data, offset, capacity);
    }

    public final void set(int index, char value) {
        this.data[this.offset + index] = value;
    }

    public final void add(char value) {
        this.data[this.offset + this.size++] = value;
    }

    @Override
    public WritableCharChunk<ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new WritableCharChunk<ATTR>(this.data, this.offset + offset, capacity);
    }

    public final char[] array() {
        return this.data;
    }

    public final int arrayOffset() {
        return this.offset;
    }

    @Override
    public final void fillWithNullValue(int offset, int length) {
        this.fillWithValue(offset, length, '\uffff');
    }

    @Override
    public final void fillWithBoxedValue(int offset, int size, Object value) {
        this.fillWithValue(offset, size, TypeUtils.unbox((Character)((Character)value)));
    }

    public final void fillWithValue(int offset, int length, char value) {
        int netOffset = this.offset + offset;
        if (length >= 16) {
            Arrays.fill(this.data, netOffset, netOffset + length, value);
            return;
        }
        for (int ii = 0; ii < length; ++ii) {
            this.data[netOffset + ii] = value;
        }
    }

    public final void appendTypedChunk(CharChunk<? extends ATTR> src, int srcOffset, int length) {
        this.copyFromTypedChunk(src, srcOffset, this.size, length);
        this.size += length;
    }

    @Override
    public final void copyFromChunk(Chunk<? extends ATTR> src, int srcOffset, int destOffset, int length) {
        CharChunk<? extends ATTR> typedSrc = src.asCharChunk();
        this.copyFromTypedChunk(typedSrc, srcOffset, destOffset, length);
    }

    public final void copyFromTypedChunk(CharChunk<? extends ATTR> src, int srcOffset, int destOffset, int length) {
        this.copyFromTypedArray(src.data, src.offset + srcOffset, destOffset, length);
    }

    @Override
    public final void copyFromArray(Object srcArray, int srcOffset, int destOffset, int length) {
        char[] typedArray = (char[])srcArray;
        this.copyFromTypedArray(typedArray, srcOffset, destOffset, length);
    }

    public final void copyFromTypedArray(char[] src, int srcOffset, int destOffset, int length) {
        int netDestOffset = this.offset + destOffset;
        if (length >= 16) {
            System.arraycopy(src, srcOffset, this.data, netDestOffset, length);
            return;
        }
        if (ChunkHelpers.canCopyForward(src, srcOffset, this.data, destOffset, length)) {
            for (int ii = 0; ii < length; ++ii) {
                this.data[netDestOffset + ii] = src[srcOffset + ii];
            }
            return;
        }
        for (int ii = length - 1; ii >= 0; --ii) {
            this.data[netDestOffset + ii] = src[srcOffset + ii];
        }
    }

    @Override
    public final void copyFromBuffer(@NotNull Buffer srcBuffer, int srcOffset, int destOffset, int length) {
        CharBuffer charSrcBuffer = (CharBuffer)srcBuffer;
        this.copyFromTypedBuffer(charSrcBuffer, srcOffset, destOffset, length);
    }

    public final void copyFromTypedBuffer(@NotNull CharBuffer srcBuffer, int srcOffset, int destOffset, int length) {
        if (srcBuffer.hasArray()) {
            this.copyFromTypedArray(srcBuffer.array(), srcBuffer.arrayOffset() + srcOffset, destOffset, length);
        } else {
            int initialPosition = srcBuffer.position();
            srcBuffer.position(srcOffset);
            srcBuffer.get(this.data, this.offset + destOffset, length);
            srcBuffer.position(initialPosition);
        }
    }

    @Override
    public final void sort() {
        this.sort(0, this.size);
    }

    @Override
    public final void sort(int start, int length) {
        Arrays.sort(this.data, this.offset + start, this.offset + start + length);
        if (length <= 1) {
            return;
        }
        int foundLeft = Arrays.binarySearch(this.data, start, start + length, '\uffff');
        if (foundLeft < 0) {
            return;
        }
        int foundRight = foundLeft;
        while (foundLeft > start && this.data[foundLeft - 1] == '\uffff') {
            --foundLeft;
        }
        if (foundLeft > 0) {
            while (foundRight < start + length - 1 && this.data[foundRight + 1] == '\uffff') {
                ++foundRight;
            }
            int nullCount = foundRight - foundLeft + 1;
            System.arraycopy(this.data, start, this.data, start + nullCount, foundLeft - start);
            Arrays.fill(this.data, start, start + nullCount, '\uffff');
        }
    }

    public void close() {
    }

    public static <ATTR extends Any, ATTR_DERIV extends ATTR> WritableCharChunk<ATTR> upcast(WritableCharChunk<ATTR_DERIV> self) {
        return self;
    }
}

