/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.CharChunkChunk;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.WritableCharChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableChunkChunk;
import io.deephaven.chunk.attributes.Any;

public class WritableCharChunkChunk<ATTR extends Any>
extends CharChunkChunk<ATTR>
implements WritableChunkChunk<ATTR> {
    WritableCharChunk<ATTR>[] writableData;

    public static <ATTR extends Any> WritableCharChunk<ATTR>[] makeArray(int capacity) {
        return new WritableCharChunk[capacity];
    }

    public static <ATTR extends Any> WritableCharChunkChunk<ATTR> makeWritableChunk(int size) {
        return WritableCharChunkChunk.writableChunkWrap(WritableCharChunkChunk.makeArray(size), 0, size);
    }

    public static <ATTR extends Any> WritableCharChunkChunk<ATTR> writableChunkWrap(WritableCharChunk<ATTR>[] data) {
        return new WritableCharChunkChunk<ATTR>(data, 0, data.length);
    }

    public static <ATTR extends Any> WritableCharChunkChunk<ATTR> writableChunkWrap(WritableCharChunk<ATTR>[] data, int offset, int size) {
        return new WritableCharChunkChunk<ATTR>(data, offset, size);
    }

    WritableCharChunkChunk(WritableCharChunk<ATTR>[] data, int offset, int capacity) {
        super(data, offset, capacity);
        this.writableData = data;
    }

    public final void set(int index, WritableCharChunk<ATTR> value) {
        this.data[this.offset + index] = value;
        this.resetInnerCacheItem(index, value);
    }

    @Override
    public final WritableCharChunk<ATTR> getWritableChunk(int pos) {
        return this.writableData[this.offset + pos];
    }

    @Override
    public final void setWritableChunk(int pos, WritableChunk<ATTR> value) {
        this.set(pos, value.asWritableCharChunk());
    }

    public final void set(int j, int i, char value) {
        this.innerData[j][this.innerOffsets[j] + i] = value;
    }

    @Override
    public WritableCharChunkChunk<ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new WritableCharChunkChunk<ATTR>(this.writableData, this.offset + offset, capacity);
    }
}

