/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.DoubleChunkChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableChunkChunk;
import io.deephaven.chunk.WritableDoubleChunk;
import io.deephaven.chunk.attributes.Any;

public class WritableDoubleChunkChunk<ATTR extends Any>
extends DoubleChunkChunk<ATTR>
implements WritableChunkChunk<ATTR> {
    WritableDoubleChunk<ATTR>[] writableData;

    public static <ATTR extends Any> WritableDoubleChunk<ATTR>[] makeArray(int capacity) {
        return new WritableDoubleChunk[capacity];
    }

    public static <ATTR extends Any> WritableDoubleChunkChunk<ATTR> makeWritableChunk(int size) {
        return WritableDoubleChunkChunk.writableChunkWrap(WritableDoubleChunkChunk.makeArray(size), 0, size);
    }

    public static <ATTR extends Any> WritableDoubleChunkChunk<ATTR> writableChunkWrap(WritableDoubleChunk<ATTR>[] data) {
        return new WritableDoubleChunkChunk<ATTR>(data, 0, data.length);
    }

    public static <ATTR extends Any> WritableDoubleChunkChunk<ATTR> writableChunkWrap(WritableDoubleChunk<ATTR>[] data, int offset, int size) {
        return new WritableDoubleChunkChunk<ATTR>(data, offset, size);
    }

    WritableDoubleChunkChunk(WritableDoubleChunk<ATTR>[] data, int offset, int capacity) {
        super(data, offset, capacity);
        this.writableData = data;
    }

    public final void set(int index, WritableDoubleChunk<ATTR> value) {
        this.data[this.offset + index] = value;
        this.resetInnerCacheItem(index, value);
    }

    @Override
    public final WritableDoubleChunk<ATTR> getWritableChunk(int pos) {
        return this.writableData[this.offset + pos];
    }

    @Override
    public final void setWritableChunk(int pos, WritableChunk<ATTR> value) {
        this.set(pos, value.asWritableDoubleChunk());
    }

    public final void set(int j, int i, double value) {
        this.innerData[j][this.innerOffsets[j] + i] = value;
    }

    @Override
    public WritableDoubleChunkChunk<ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new WritableDoubleChunkChunk<ATTR>(this.writableData, this.offset + offset, capacity);
    }
}

