/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.FloatChunkChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableChunkChunk;
import io.deephaven.chunk.WritableFloatChunk;
import io.deephaven.chunk.attributes.Any;

public class WritableFloatChunkChunk<ATTR extends Any>
extends FloatChunkChunk<ATTR>
implements WritableChunkChunk<ATTR> {
    WritableFloatChunk<ATTR>[] writableData;

    public static <ATTR extends Any> WritableFloatChunk<ATTR>[] makeArray(int capacity) {
        return new WritableFloatChunk[capacity];
    }

    public static <ATTR extends Any> WritableFloatChunkChunk<ATTR> makeWritableChunk(int size) {
        return WritableFloatChunkChunk.writableChunkWrap(WritableFloatChunkChunk.makeArray(size), 0, size);
    }

    public static <ATTR extends Any> WritableFloatChunkChunk<ATTR> writableChunkWrap(WritableFloatChunk<ATTR>[] data) {
        return new WritableFloatChunkChunk<ATTR>(data, 0, data.length);
    }

    public static <ATTR extends Any> WritableFloatChunkChunk<ATTR> writableChunkWrap(WritableFloatChunk<ATTR>[] data, int offset, int size) {
        return new WritableFloatChunkChunk<ATTR>(data, offset, size);
    }

    WritableFloatChunkChunk(WritableFloatChunk<ATTR>[] data, int offset, int capacity) {
        super(data, offset, capacity);
        this.writableData = data;
    }

    public final void set(int index, WritableFloatChunk<ATTR> value) {
        this.data[this.offset + index] = value;
        this.resetInnerCacheItem(index, value);
    }

    @Override
    public final WritableFloatChunk<ATTR> getWritableChunk(int pos) {
        return this.writableData[this.offset + pos];
    }

    @Override
    public final void setWritableChunk(int pos, WritableChunk<ATTR> value) {
        this.set(pos, value.asWritableFloatChunk());
    }

    public final void set(int j, int i, float value) {
        this.innerData[j][this.innerOffsets[j] + i] = value;
    }

    @Override
    public WritableFloatChunkChunk<ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new WritableFloatChunkChunk<ATTR>(this.writableData, this.offset + offset, capacity);
    }
}

