/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.IntChunkChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableChunkChunk;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.attributes.Any;

public class WritableIntChunkChunk<ATTR extends Any>
extends IntChunkChunk<ATTR>
implements WritableChunkChunk<ATTR> {
    WritableIntChunk<ATTR>[] writableData;

    public static <ATTR extends Any> WritableIntChunk<ATTR>[] makeArray(int capacity) {
        return new WritableIntChunk[capacity];
    }

    public static <ATTR extends Any> WritableIntChunkChunk<ATTR> makeWritableChunk(int size) {
        return WritableIntChunkChunk.writableChunkWrap(WritableIntChunkChunk.makeArray(size), 0, size);
    }

    public static <ATTR extends Any> WritableIntChunkChunk<ATTR> writableChunkWrap(WritableIntChunk<ATTR>[] data) {
        return new WritableIntChunkChunk<ATTR>(data, 0, data.length);
    }

    public static <ATTR extends Any> WritableIntChunkChunk<ATTR> writableChunkWrap(WritableIntChunk<ATTR>[] data, int offset, int size) {
        return new WritableIntChunkChunk<ATTR>(data, offset, size);
    }

    WritableIntChunkChunk(WritableIntChunk<ATTR>[] data, int offset, int capacity) {
        super(data, offset, capacity);
        this.writableData = data;
    }

    public final void set(int index, WritableIntChunk<ATTR> value) {
        this.data[this.offset + index] = value;
        this.resetInnerCacheItem(index, value);
    }

    @Override
    public final WritableIntChunk<ATTR> getWritableChunk(int pos) {
        return this.writableData[this.offset + pos];
    }

    @Override
    public final void setWritableChunk(int pos, WritableChunk<ATTR> value) {
        this.set(pos, value.asWritableIntChunk());
    }

    public final void set(int j, int i, int value) {
        this.innerData[j][this.innerOffsets[j] + i] = value;
    }

    @Override
    public WritableIntChunkChunk<ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new WritableIntChunkChunk<ATTR>(this.writableData, this.offset + offset, capacity);
    }
}

