/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.pools.MultiChunkPool;
import io.deephaven.util.type.TypeUtils;
import java.nio.Buffer;
import java.nio.LongBuffer;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class WritableLongChunk<ATTR extends Any>
extends LongChunk<ATTR>
implements WritableChunk<ATTR> {
    private static final WritableLongChunk[] EMPTY_WRITABLE_LONG_CHUNK_ARRAY = new WritableLongChunk[0];

    static <ATTR extends Any> WritableLongChunk<ATTR>[] getEmptyChunkArray() {
        return EMPTY_WRITABLE_LONG_CHUNK_ARRAY;
    }

    public static <ATTR extends Any> WritableLongChunk<ATTR> makeWritableChunk(int size) {
        return MultiChunkPool.forThisThread().takeWritableLongChunk(size);
    }

    public static <ATTR extends Any> WritableLongChunk<ATTR> makeWritableChunkForPool(int size) {
        return new WritableLongChunk<ATTR>(WritableLongChunk.makeArray(size), 0, size){

            @Override
            public void close() {
                MultiChunkPool.forThisThread().giveWritableLongChunk(this);
            }
        };
    }

    public static <ATTR extends Any> WritableLongChunk<ATTR> writableChunkWrap(long[] data) {
        return WritableLongChunk.writableChunkWrap(data, 0, data.length);
    }

    public static <ATTR extends Any> WritableLongChunk<ATTR> writableChunkWrap(long[] data, int offset, int size) {
        return new WritableLongChunk<ATTR>(data, offset, size);
    }

    protected WritableLongChunk(long[] data, int offset, int capacity) {
        super(data, offset, capacity);
    }

    public final void set(int index, long value) {
        this.data[this.offset + index] = value;
    }

    public final void add(long value) {
        this.data[this.offset + this.size++] = value;
    }

    @Override
    public WritableLongChunk<ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new WritableLongChunk<ATTR>(this.data, this.offset + offset, capacity);
    }

    public final long[] array() {
        return this.data;
    }

    public final int arrayOffset() {
        return this.offset;
    }

    @Override
    public final void fillWithNullValue(int offset, int length) {
        this.fillWithValue(offset, length, Long.MIN_VALUE);
    }

    @Override
    public final void fillWithBoxedValue(int offset, int size, Object value) {
        this.fillWithValue(offset, size, TypeUtils.unbox((Long)((Long)value)));
    }

    public final void fillWithValue(int offset, int length, long value) {
        int netOffset = this.offset + offset;
        if (length >= 16) {
            Arrays.fill(this.data, netOffset, netOffset + length, value);
            return;
        }
        for (int ii = 0; ii < length; ++ii) {
            this.data[netOffset + ii] = value;
        }
    }

    public final void appendTypedChunk(LongChunk<? extends ATTR> src, int srcOffset, int length) {
        this.copyFromTypedChunk(src, srcOffset, this.size, length);
        this.size += length;
    }

    @Override
    public final void copyFromChunk(Chunk<? extends ATTR> src, int srcOffset, int destOffset, int length) {
        LongChunk<? extends ATTR> typedSrc = src.asLongChunk();
        this.copyFromTypedChunk(typedSrc, srcOffset, destOffset, length);
    }

    public final void copyFromTypedChunk(LongChunk<? extends ATTR> src, int srcOffset, int destOffset, int length) {
        this.copyFromTypedArray(src.data, src.offset + srcOffset, destOffset, length);
    }

    @Override
    public final void copyFromArray(Object srcArray, int srcOffset, int destOffset, int length) {
        long[] typedArray = (long[])srcArray;
        this.copyFromTypedArray(typedArray, srcOffset, destOffset, length);
    }

    public final void copyFromTypedArray(long[] src, int srcOffset, int destOffset, int length) {
        int netDestOffset = this.offset + destOffset;
        if (length >= 16) {
            System.arraycopy(src, srcOffset, this.data, netDestOffset, length);
            return;
        }
        if (ChunkHelpers.canCopyForward(src, srcOffset, this.data, destOffset, length)) {
            for (int ii = 0; ii < length; ++ii) {
                this.data[netDestOffset + ii] = src[srcOffset + ii];
            }
            return;
        }
        for (int ii = length - 1; ii >= 0; --ii) {
            this.data[netDestOffset + ii] = src[srcOffset + ii];
        }
    }

    @Override
    public final void copyFromBuffer(@NotNull Buffer srcBuffer, int srcOffset, int destOffset, int length) {
        LongBuffer longSrcBuffer = (LongBuffer)srcBuffer;
        this.copyFromTypedBuffer(longSrcBuffer, srcOffset, destOffset, length);
    }

    public final void copyFromTypedBuffer(@NotNull LongBuffer srcBuffer, int srcOffset, int destOffset, int length) {
        if (srcBuffer.hasArray()) {
            this.copyFromTypedArray(srcBuffer.array(), srcBuffer.arrayOffset() + srcOffset, destOffset, length);
        } else {
            int initialPosition = srcBuffer.position();
            srcBuffer.position(srcOffset);
            srcBuffer.get(this.data, this.offset + destOffset, length);
            srcBuffer.position(initialPosition);
        }
    }

    @Override
    public final void sort() {
        this.sort(0, this.size);
    }

    @Override
    public final void sort(int start, int length) {
        Arrays.sort(this.data, this.offset + start, this.offset + start + length);
    }

    public void close() {
    }

    public static <ATTR extends Any, ATTR_DERIV extends ATTR> WritableLongChunk<ATTR> upcast(WritableLongChunk<ATTR_DERIV> self) {
        return self;
    }
}

