/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.LongChunkChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableChunkChunk;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.chunk.attributes.Any;

public class WritableLongChunkChunk<ATTR extends Any>
extends LongChunkChunk<ATTR>
implements WritableChunkChunk<ATTR> {
    WritableLongChunk<ATTR>[] writableData;

    public static <ATTR extends Any> WritableLongChunk<ATTR>[] makeArray(int capacity) {
        return new WritableLongChunk[capacity];
    }

    public static <ATTR extends Any> WritableLongChunkChunk<ATTR> makeWritableChunk(int size) {
        return WritableLongChunkChunk.writableChunkWrap(WritableLongChunkChunk.makeArray(size), 0, size);
    }

    public static <ATTR extends Any> WritableLongChunkChunk<ATTR> writableChunkWrap(WritableLongChunk<ATTR>[] data) {
        return new WritableLongChunkChunk<ATTR>(data, 0, data.length);
    }

    public static <ATTR extends Any> WritableLongChunkChunk<ATTR> writableChunkWrap(WritableLongChunk<ATTR>[] data, int offset, int size) {
        return new WritableLongChunkChunk<ATTR>(data, offset, size);
    }

    WritableLongChunkChunk(WritableLongChunk<ATTR>[] data, int offset, int capacity) {
        super(data, offset, capacity);
        this.writableData = data;
    }

    public final void set(int index, WritableLongChunk<ATTR> value) {
        this.data[this.offset + index] = value;
        this.resetInnerCacheItem(index, value);
    }

    @Override
    public final WritableLongChunk<ATTR> getWritableChunk(int pos) {
        return this.writableData[this.offset + pos];
    }

    @Override
    public final void setWritableChunk(int pos, WritableChunk<ATTR> value) {
        this.set(pos, value.asWritableLongChunk());
    }

    public final void set(int j, int i, long value) {
        this.innerData[j][this.innerOffsets[j] + i] = value;
    }

    @Override
    public WritableLongChunkChunk<ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new WritableLongChunkChunk<ATTR>(this.writableData, this.offset + offset, capacity);
    }
}

