/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.pools.MultiChunkPool;
import java.util.Arrays;
import java.util.Comparator;

public class WritableObjectChunk<T, ATTR extends Any>
extends ObjectChunk<T, ATTR>
implements WritableChunk<ATTR> {
    private static final WritableObjectChunk[] EMPTY_WRITABLE_OBJECT_CHUNK_ARRAY = new WritableObjectChunk[0];
    private static final Comparator<Comparable<Object>> COMPARATOR = Comparator.nullsFirst(Comparator.naturalOrder());

    static <T, ATTR extends Any> WritableObjectChunk<T, ATTR>[] getEmptyChunkArray() {
        return EMPTY_WRITABLE_OBJECT_CHUNK_ARRAY;
    }

    public static <T, ATTR extends Any> WritableObjectChunk<T, ATTR> makeWritableChunk(int size) {
        return MultiChunkPool.forThisThread().takeWritableObjectChunk(size);
    }

    public static <T, ATTR extends Any> WritableObjectChunk<T, ATTR> makeWritableChunkForPool(int size) {
        return new WritableObjectChunk<T, ATTR>((Object[])WritableObjectChunk.makeArray(size), 0, size){

            @Override
            public void close() {
                MultiChunkPool.forThisThread().giveWritableObjectChunk(this);
            }
        };
    }

    public static <T, ATTR extends Any> WritableObjectChunk<T, ATTR> writableChunkWrap(T[] data) {
        return WritableObjectChunk.writableChunkWrap(data, 0, data.length);
    }

    public static <T, ATTR extends Any> WritableObjectChunk<T, ATTR> writableChunkWrap(T[] data, int offset, int size) {
        return new WritableObjectChunk<T, ATTR>(data, offset, size);
    }

    protected WritableObjectChunk(T[] data, int offset, int capacity) {
        super(data, offset, capacity);
    }

    public final void set(int index, T value) {
        this.data[this.offset + index] = value;
    }

    public final void add(T value) {
        this.data[this.offset + this.size++] = value;
    }

    @Override
    public WritableObjectChunk<T, ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new WritableObjectChunk<Object, ATTR>(this.data, this.offset + offset, capacity);
    }

    public final T[] array() {
        return this.data;
    }

    public final int arrayOffset() {
        return this.offset;
    }

    @Override
    public final void fillWithNullValue(int offset, int length) {
        this.fillWithValue(offset, length, null);
    }

    @Override
    public final void fillWithBoxedValue(int offset, int size, Object value) {
        this.fillWithValue(offset, size, value);
    }

    public final void fillWithValue(int offset, int length, T value) {
        int netOffset = this.offset + offset;
        if (length >= 16) {
            Arrays.fill(this.data, netOffset, netOffset + length, value);
            return;
        }
        for (int ii = 0; ii < length; ++ii) {
            this.data[netOffset + ii] = value;
        }
    }

    public final void appendTypedChunk(ObjectChunk<T, ? extends ATTR> src, int srcOffset, int length) {
        this.copyFromTypedChunk(src, srcOffset, this.size, length);
        this.size += length;
    }

    @Override
    public final void copyFromChunk(Chunk<? extends ATTR> src, int srcOffset, int destOffset, int length) {
        ObjectChunk typedSrc = src.asObjectChunk();
        this.copyFromTypedChunk(typedSrc, srcOffset, destOffset, length);
    }

    public final void copyFromTypedChunk(ObjectChunk<T, ? extends ATTR> src, int srcOffset, int destOffset, int length) {
        this.copyFromTypedArray(src.data, src.offset + srcOffset, destOffset, length);
    }

    @Override
    public final void copyFromArray(Object srcArray, int srcOffset, int destOffset, int length) {
        Object[] typedArray = (Object[])srcArray;
        this.copyFromTypedArray(typedArray, srcOffset, destOffset, length);
    }

    public final void copyFromTypedArray(T[] src, int srcOffset, int destOffset, int length) {
        int netDestOffset = this.offset + destOffset;
        if (length >= 16) {
            System.arraycopy(src, srcOffset, this.data, netDestOffset, length);
            return;
        }
        if (ChunkHelpers.canCopyForward(src, srcOffset, this.data, destOffset, length)) {
            for (int ii = 0; ii < length; ++ii) {
                this.data[netDestOffset + ii] = src[srcOffset + ii];
            }
            return;
        }
        for (int ii = length - 1; ii >= 0; --ii) {
            this.data[netDestOffset + ii] = src[srcOffset + ii];
        }
    }

    @Override
    public final void sort() {
        this.sort(0, this.size);
    }

    @Override
    public final void sort(int start, int length) {
        Arrays.sort(this.data, this.offset + start, this.offset + start + length, COMPARATOR);
    }

    public void close() {
    }

    public <T_DERIV extends T> WritableObjectChunk<T_DERIV, ATTR> asTypedWritableObjectChunk() {
        return this;
    }

    public static <T, ATTR extends Any, ATTR_DERIV extends ATTR> WritableObjectChunk<T, ATTR> upcast(WritableObjectChunk<T, ATTR_DERIV> self) {
        return self;
    }
}

