/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.ObjectChunkChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableChunkChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Any;

public class WritableObjectChunkChunk<T, ATTR extends Any>
extends ObjectChunkChunk<T, ATTR>
implements WritableChunkChunk<ATTR> {
    WritableObjectChunk<T, ATTR>[] writableData;

    public static <T, ATTR extends Any> WritableObjectChunk<T, ATTR>[] makeArray(int capacity) {
        return new WritableObjectChunk[capacity];
    }

    public static <T, ATTR extends Any> WritableObjectChunkChunk<T, ATTR> makeWritableChunk(int size) {
        return WritableObjectChunkChunk.writableChunkWrap(WritableObjectChunkChunk.makeArray(size), 0, size);
    }

    public static <T, ATTR extends Any> WritableObjectChunkChunk<T, ATTR> writableChunkWrap(WritableObjectChunk<T, ATTR>[] data) {
        return new WritableObjectChunkChunk<T, ATTR>(data, 0, data.length);
    }

    public static <T, ATTR extends Any> WritableObjectChunkChunk<T, ATTR> writableChunkWrap(WritableObjectChunk<T, ATTR>[] data, int offset, int size) {
        return new WritableObjectChunkChunk<T, ATTR>(data, offset, size);
    }

    WritableObjectChunkChunk(WritableObjectChunk<T, ATTR>[] data, int offset, int capacity) {
        super(data, offset, capacity);
        this.writableData = data;
    }

    public final void set(int index, WritableObjectChunk<T, ATTR> value) {
        this.data[this.offset + index] = value;
        this.resetInnerCacheItem(index, value);
    }

    public final WritableObjectChunk<T, ATTR> getWritableChunk(int pos) {
        return this.writableData[this.offset + pos];
    }

    @Override
    public final void setWritableChunk(int pos, WritableChunk<ATTR> value) {
        this.set(pos, value.asWritableObjectChunk());
    }

    public final void set(int j, int i, T value) {
        this.innerData[j][this.innerOffsets[j] + i] = value;
    }

    @Override
    public WritableObjectChunkChunk<T, ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new WritableObjectChunkChunk<T, ATTR>(this.writableData, this.offset + offset, capacity);
    }
}

