/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.pools.MultiChunkPool;
import io.deephaven.util.type.TypeUtils;
import java.nio.Buffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class WritableShortChunk<ATTR extends Any>
extends ShortChunk<ATTR>
implements WritableChunk<ATTR> {
    private static final WritableShortChunk[] EMPTY_WRITABLE_SHORT_CHUNK_ARRAY = new WritableShortChunk[0];

    static <ATTR extends Any> WritableShortChunk<ATTR>[] getEmptyChunkArray() {
        return EMPTY_WRITABLE_SHORT_CHUNK_ARRAY;
    }

    public static <ATTR extends Any> WritableShortChunk<ATTR> makeWritableChunk(int size) {
        return MultiChunkPool.forThisThread().takeWritableShortChunk(size);
    }

    public static <ATTR extends Any> WritableShortChunk<ATTR> makeWritableChunkForPool(int size) {
        return new WritableShortChunk<ATTR>(WritableShortChunk.makeArray(size), 0, size){

            @Override
            public void close() {
                MultiChunkPool.forThisThread().giveWritableShortChunk(this);
            }
        };
    }

    public static <ATTR extends Any> WritableShortChunk<ATTR> writableChunkWrap(short[] data) {
        return WritableShortChunk.writableChunkWrap(data, 0, data.length);
    }

    public static <ATTR extends Any> WritableShortChunk<ATTR> writableChunkWrap(short[] data, int offset, int size) {
        return new WritableShortChunk<ATTR>(data, offset, size);
    }

    protected WritableShortChunk(short[] data, int offset, int capacity) {
        super(data, offset, capacity);
    }

    public final void set(int index, short value) {
        this.data[this.offset + index] = value;
    }

    public final void add(short value) {
        this.data[this.offset + this.size++] = value;
    }

    @Override
    public WritableShortChunk<ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new WritableShortChunk<ATTR>(this.data, this.offset + offset, capacity);
    }

    public final short[] array() {
        return this.data;
    }

    public final int arrayOffset() {
        return this.offset;
    }

    @Override
    public final void fillWithNullValue(int offset, int length) {
        this.fillWithValue(offset, length, (short)Short.MIN_VALUE);
    }

    @Override
    public final void fillWithBoxedValue(int offset, int size, Object value) {
        this.fillWithValue(offset, size, TypeUtils.unbox((Short)((Short)value)));
    }

    public final void fillWithValue(int offset, int length, short value) {
        int netOffset = this.offset + offset;
        if (length >= 16) {
            Arrays.fill(this.data, netOffset, netOffset + length, value);
            return;
        }
        for (int ii = 0; ii < length; ++ii) {
            this.data[netOffset + ii] = value;
        }
    }

    public final void appendTypedChunk(ShortChunk<? extends ATTR> src, int srcOffset, int length) {
        this.copyFromTypedChunk(src, srcOffset, this.size, length);
        this.size += length;
    }

    @Override
    public final void copyFromChunk(Chunk<? extends ATTR> src, int srcOffset, int destOffset, int length) {
        ShortChunk<? extends ATTR> typedSrc = src.asShortChunk();
        this.copyFromTypedChunk(typedSrc, srcOffset, destOffset, length);
    }

    public final void copyFromTypedChunk(ShortChunk<? extends ATTR> src, int srcOffset, int destOffset, int length) {
        this.copyFromTypedArray(src.data, src.offset + srcOffset, destOffset, length);
    }

    @Override
    public final void copyFromArray(Object srcArray, int srcOffset, int destOffset, int length) {
        short[] typedArray = (short[])srcArray;
        this.copyFromTypedArray(typedArray, srcOffset, destOffset, length);
    }

    public final void copyFromTypedArray(short[] src, int srcOffset, int destOffset, int length) {
        int netDestOffset = this.offset + destOffset;
        if (length >= 16) {
            System.arraycopy(src, srcOffset, this.data, netDestOffset, length);
            return;
        }
        if (ChunkHelpers.canCopyForward(src, srcOffset, this.data, destOffset, length)) {
            for (int ii = 0; ii < length; ++ii) {
                this.data[netDestOffset + ii] = src[srcOffset + ii];
            }
            return;
        }
        for (int ii = length - 1; ii >= 0; --ii) {
            this.data[netDestOffset + ii] = src[srcOffset + ii];
        }
    }

    @Override
    public final void copyFromBuffer(@NotNull Buffer srcBuffer, int srcOffset, int destOffset, int length) {
        ShortBuffer shortSrcBuffer = (ShortBuffer)srcBuffer;
        this.copyFromTypedBuffer(shortSrcBuffer, srcOffset, destOffset, length);
    }

    public final void copyFromTypedBuffer(@NotNull ShortBuffer srcBuffer, int srcOffset, int destOffset, int length) {
        if (srcBuffer.hasArray()) {
            this.copyFromTypedArray(srcBuffer.array(), srcBuffer.arrayOffset() + srcOffset, destOffset, length);
        } else {
            int initialPosition = srcBuffer.position();
            srcBuffer.position(srcOffset);
            srcBuffer.get(this.data, this.offset + destOffset, length);
            srcBuffer.position(initialPosition);
        }
    }

    @Override
    public final void sort() {
        this.sort(0, this.size);
    }

    @Override
    public final void sort(int start, int length) {
        Arrays.sort(this.data, this.offset + start, this.offset + start + length);
    }

    public void close() {
    }

    public static <ATTR extends Any, ATTR_DERIV extends ATTR> WritableShortChunk<ATTR> upcast(WritableShortChunk<ATTR_DERIV> self) {
        return self;
    }
}

