/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.ShortChunkChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableChunkChunk;
import io.deephaven.chunk.WritableShortChunk;
import io.deephaven.chunk.attributes.Any;

public class WritableShortChunkChunk<ATTR extends Any>
extends ShortChunkChunk<ATTR>
implements WritableChunkChunk<ATTR> {
    WritableShortChunk<ATTR>[] writableData;

    public static <ATTR extends Any> WritableShortChunk<ATTR>[] makeArray(int capacity) {
        return new WritableShortChunk[capacity];
    }

    public static <ATTR extends Any> WritableShortChunkChunk<ATTR> makeWritableChunk(int size) {
        return WritableShortChunkChunk.writableChunkWrap(WritableShortChunkChunk.makeArray(size), 0, size);
    }

    public static <ATTR extends Any> WritableShortChunkChunk<ATTR> writableChunkWrap(WritableShortChunk<ATTR>[] data) {
        return new WritableShortChunkChunk<ATTR>(data, 0, data.length);
    }

    public static <ATTR extends Any> WritableShortChunkChunk<ATTR> writableChunkWrap(WritableShortChunk<ATTR>[] data, int offset, int size) {
        return new WritableShortChunkChunk<ATTR>(data, offset, size);
    }

    WritableShortChunkChunk(WritableShortChunk<ATTR>[] data, int offset, int capacity) {
        super(data, offset, capacity);
        this.writableData = data;
    }

    public final void set(int index, WritableShortChunk<ATTR> value) {
        this.data[this.offset + index] = value;
        this.resetInnerCacheItem(index, value);
    }

    @Override
    public final WritableShortChunk<ATTR> getWritableChunk(int pos) {
        return this.writableData[this.offset + pos];
    }

    @Override
    public final void setWritableChunk(int pos, WritableChunk<ATTR> value) {
        this.set(pos, value.asWritableShortChunk());
    }

    public final void set(int j, int i, short value) {
        this.innerData[j][this.innerOffsets[j] + i] = value;
    }

    @Override
    public WritableShortChunkChunk<ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new WritableShortChunkChunk<ATTR>(this.writableData, this.offset + offset, capacity);
    }
}

