/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.sized;

import io.deephaven.chunk.WritableBooleanChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.util.SafeCloseable;

public final class SizedBooleanChunk<T extends Any>
implements SafeCloseable {
    private WritableBooleanChunk<T> chunk;

    public SizedBooleanChunk() {
    }

    public SizedBooleanChunk(int initialSize) {
        this.chunk = WritableBooleanChunk.makeWritableChunk(initialSize);
    }

    public WritableBooleanChunk<T> get() {
        return this.chunk;
    }

    public WritableBooleanChunk<T> ensureCapacity(int capacity) {
        if (this.chunk == null || capacity > this.chunk.capacity()) {
            if (this.chunk != null) {
                this.chunk.close();
            }
            this.chunk = WritableBooleanChunk.makeWritableChunk(capacity);
        }
        return this.chunk;
    }

    public WritableBooleanChunk<T> ensureCapacityPreserve(int capacity) {
        if (this.chunk == null || capacity > this.chunk.capacity()) {
            WritableBooleanChunk<T> oldChunk = this.chunk;
            this.chunk = WritableBooleanChunk.makeWritableChunk(capacity);
            if (oldChunk != null) {
                this.chunk.copyFromTypedChunk(oldChunk, 0, 0, oldChunk.size());
                this.chunk.setSize(oldChunk.size());
                oldChunk.close();
            } else {
                this.chunk.setSize(0);
            }
        }
        return this.chunk;
    }

    public void close() {
        if (this.chunk != null) {
            this.chunk.close();
            this.chunk = null;
        }
    }
}

