/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.sized;

import io.deephaven.chunk.WritableByteChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.util.SafeCloseable;

public final class SizedByteChunk<T extends Any>
implements SafeCloseable {
    private WritableByteChunk<T> chunk;

    public SizedByteChunk() {
    }

    public SizedByteChunk(int initialSize) {
        this.chunk = WritableByteChunk.makeWritableChunk(initialSize);
    }

    public WritableByteChunk<T> get() {
        return this.chunk;
    }

    public WritableByteChunk<T> ensureCapacity(int capacity) {
        if (this.chunk == null || capacity > this.chunk.capacity()) {
            if (this.chunk != null) {
                this.chunk.close();
            }
            this.chunk = WritableByteChunk.makeWritableChunk(capacity);
        }
        return this.chunk;
    }

    public WritableByteChunk<T> ensureCapacityPreserve(int capacity) {
        if (this.chunk == null || capacity > this.chunk.capacity()) {
            WritableByteChunk<T> oldChunk = this.chunk;
            this.chunk = WritableByteChunk.makeWritableChunk(capacity);
            if (oldChunk != null) {
                this.chunk.copyFromTypedChunk(oldChunk, 0, 0, oldChunk.size());
                this.chunk.setSize(oldChunk.size());
                oldChunk.close();
            } else {
                this.chunk.setSize(0);
            }
        }
        return this.chunk;
    }

    public void close() {
        if (this.chunk != null) {
            this.chunk.close();
            this.chunk = null;
        }
    }
}

