/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.sized;

import io.deephaven.chunk.WritableCharChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.util.SafeCloseable;

public final class SizedCharChunk<T extends Any>
implements SafeCloseable {
    private WritableCharChunk<T> chunk;

    public SizedCharChunk() {
    }

    public SizedCharChunk(int initialSize) {
        this.chunk = WritableCharChunk.makeWritableChunk(initialSize);
    }

    public WritableCharChunk<T> get() {
        return this.chunk;
    }

    public WritableCharChunk<T> ensureCapacity(int capacity) {
        if (this.chunk == null || capacity > this.chunk.capacity()) {
            if (this.chunk != null) {
                this.chunk.close();
            }
            this.chunk = WritableCharChunk.makeWritableChunk(capacity);
        }
        return this.chunk;
    }

    public WritableCharChunk<T> ensureCapacityPreserve(int capacity) {
        if (this.chunk == null || capacity > this.chunk.capacity()) {
            WritableCharChunk<T> oldChunk = this.chunk;
            this.chunk = WritableCharChunk.makeWritableChunk(capacity);
            if (oldChunk != null) {
                this.chunk.copyFromTypedChunk(oldChunk, 0, 0, oldChunk.size());
                this.chunk.setSize(oldChunk.size());
                oldChunk.close();
            } else {
                this.chunk.setSize(0);
            }
        }
        return this.chunk;
    }

    public void close() {
        if (this.chunk != null) {
            this.chunk.close();
            this.chunk = null;
        }
    }
}

