/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.sized;

import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.util.SafeCloseable;

public class SizedChunk<T extends Any>
implements SafeCloseable {
    private final ChunkType chunkType;
    private WritableChunk<T> chunk;

    public SizedChunk(ChunkType chunkType) {
        this.chunkType = chunkType;
    }

    public WritableChunk<T> get() {
        return this.chunk;
    }

    public WritableChunk<T> ensureCapacity(int capacity) {
        if (this.chunk == null || capacity > this.chunk.capacity()) {
            if (this.chunk != null) {
                this.chunk.close();
            }
            this.chunk = this.chunkType.makeWritableChunk(capacity);
        }
        return this.chunk;
    }

    public WritableChunk<T> ensureCapacityPreserve(int capacity) {
        if (this.chunk == null || capacity > this.chunk.capacity()) {
            WritableChunk<T> oldChunk = this.chunk;
            this.chunk = this.chunkType.makeWritableChunk(capacity);
            if (oldChunk != null) {
                this.chunk.copyFromChunk(oldChunk, 0, 0, oldChunk.size());
                this.chunk.setSize(oldChunk.size());
                oldChunk.close();
            } else {
                this.chunk.setSize(0);
            }
        }
        return this.chunk;
    }

    public void close() {
        if (this.chunk != null) {
            this.chunk.close();
            this.chunk = null;
        }
    }
}

