/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.sized;

import io.deephaven.chunk.WritableDoubleChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.util.SafeCloseable;

public final class SizedDoubleChunk<T extends Any>
implements SafeCloseable {
    private WritableDoubleChunk<T> chunk;

    public SizedDoubleChunk() {
    }

    public SizedDoubleChunk(int initialSize) {
        this.chunk = WritableDoubleChunk.makeWritableChunk(initialSize);
    }

    public WritableDoubleChunk<T> get() {
        return this.chunk;
    }

    public WritableDoubleChunk<T> ensureCapacity(int capacity) {
        if (this.chunk == null || capacity > this.chunk.capacity()) {
            if (this.chunk != null) {
                this.chunk.close();
            }
            this.chunk = WritableDoubleChunk.makeWritableChunk(capacity);
        }
        return this.chunk;
    }

    public WritableDoubleChunk<T> ensureCapacityPreserve(int capacity) {
        if (this.chunk == null || capacity > this.chunk.capacity()) {
            WritableDoubleChunk<T> oldChunk = this.chunk;
            this.chunk = WritableDoubleChunk.makeWritableChunk(capacity);
            if (oldChunk != null) {
                this.chunk.copyFromTypedChunk(oldChunk, 0, 0, oldChunk.size());
                this.chunk.setSize(oldChunk.size());
                oldChunk.close();
            } else {
                this.chunk.setSize(0);
            }
        }
        return this.chunk;
    }

    public void close() {
        if (this.chunk != null) {
            this.chunk.close();
            this.chunk = null;
        }
    }
}

