/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.sized;

import io.deephaven.chunk.WritableFloatChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.util.SafeCloseable;

public final class SizedFloatChunk<T extends Any>
implements SafeCloseable {
    private WritableFloatChunk<T> chunk;

    public SizedFloatChunk() {
    }

    public SizedFloatChunk(int initialSize) {
        this.chunk = WritableFloatChunk.makeWritableChunk(initialSize);
    }

    public WritableFloatChunk<T> get() {
        return this.chunk;
    }

    public WritableFloatChunk<T> ensureCapacity(int capacity) {
        if (this.chunk == null || capacity > this.chunk.capacity()) {
            if (this.chunk != null) {
                this.chunk.close();
            }
            this.chunk = WritableFloatChunk.makeWritableChunk(capacity);
        }
        return this.chunk;
    }

    public WritableFloatChunk<T> ensureCapacityPreserve(int capacity) {
        if (this.chunk == null || capacity > this.chunk.capacity()) {
            WritableFloatChunk<T> oldChunk = this.chunk;
            this.chunk = WritableFloatChunk.makeWritableChunk(capacity);
            if (oldChunk != null) {
                this.chunk.copyFromTypedChunk(oldChunk, 0, 0, oldChunk.size());
                this.chunk.setSize(oldChunk.size());
                oldChunk.close();
            } else {
                this.chunk.setSize(0);
            }
        }
        return this.chunk;
    }

    public void close() {
        if (this.chunk != null) {
            this.chunk.close();
            this.chunk = null;
        }
    }
}

