/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.sized;

import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.util.SafeCloseable;

public final class SizedIntChunk<T extends Any>
implements SafeCloseable {
    private WritableIntChunk<T> chunk;

    public SizedIntChunk() {
    }

    public SizedIntChunk(int initialSize) {
        this.chunk = WritableIntChunk.makeWritableChunk(initialSize);
    }

    public WritableIntChunk<T> get() {
        return this.chunk;
    }

    public WritableIntChunk<T> ensureCapacity(int capacity) {
        if (this.chunk == null || capacity > this.chunk.capacity()) {
            if (this.chunk != null) {
                this.chunk.close();
            }
            this.chunk = WritableIntChunk.makeWritableChunk(capacity);
        }
        return this.chunk;
    }

    public WritableIntChunk<T> ensureCapacityPreserve(int capacity) {
        if (this.chunk == null || capacity > this.chunk.capacity()) {
            WritableIntChunk<T> oldChunk = this.chunk;
            this.chunk = WritableIntChunk.makeWritableChunk(capacity);
            if (oldChunk != null) {
                this.chunk.copyFromTypedChunk(oldChunk, 0, 0, oldChunk.size());
                this.chunk.setSize(oldChunk.size());
                oldChunk.close();
            } else {
                this.chunk.setSize(0);
            }
        }
        return this.chunk;
    }

    public void close() {
        if (this.chunk != null) {
            this.chunk.close();
            this.chunk = null;
        }
    }
}

