/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.sized;

import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.util.SafeCloseable;

public final class SizedLongChunk<T extends Any>
implements SafeCloseable {
    private WritableLongChunk<T> chunk;

    public SizedLongChunk() {
    }

    public SizedLongChunk(int initialSize) {
        this.chunk = WritableLongChunk.makeWritableChunk(initialSize);
    }

    public WritableLongChunk<T> get() {
        return this.chunk;
    }

    public WritableLongChunk<T> ensureCapacity(int capacity) {
        if (this.chunk == null || capacity > this.chunk.capacity()) {
            if (this.chunk != null) {
                this.chunk.close();
            }
            this.chunk = WritableLongChunk.makeWritableChunk(capacity);
        }
        return this.chunk;
    }

    public WritableLongChunk<T> ensureCapacityPreserve(int capacity) {
        if (this.chunk == null || capacity > this.chunk.capacity()) {
            WritableLongChunk<T> oldChunk = this.chunk;
            this.chunk = WritableLongChunk.makeWritableChunk(capacity);
            if (oldChunk != null) {
                this.chunk.copyFromTypedChunk(oldChunk, 0, 0, oldChunk.size());
                this.chunk.setSize(oldChunk.size());
                oldChunk.close();
            } else {
                this.chunk.setSize(0);
            }
        }
        return this.chunk;
    }

    public void close() {
        if (this.chunk != null) {
            this.chunk.close();
            this.chunk = null;
        }
    }
}

