/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.sized;

import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.util.SafeCloseable;

public final class SizedObjectChunk<T, ATTR extends Any>
implements SafeCloseable {
    private WritableObjectChunk<T, ATTR> chunk;

    public SizedObjectChunk() {
    }

    public SizedObjectChunk(int initialSize) {
        this.chunk = WritableObjectChunk.makeWritableChunk(initialSize);
    }

    public WritableObjectChunk<T, ATTR> get() {
        return this.chunk;
    }

    public WritableObjectChunk<T, ATTR> ensureCapacity(int capacity) {
        if (this.chunk == null || capacity > this.chunk.capacity()) {
            if (this.chunk != null) {
                this.chunk.close();
            }
            this.chunk = WritableObjectChunk.makeWritableChunk(capacity);
        }
        return this.chunk;
    }

    public WritableObjectChunk<T, ATTR> ensureCapacityPreserve(int capacity) {
        if (this.chunk == null || capacity > this.chunk.capacity()) {
            WritableObjectChunk<T, ATTR> oldChunk = this.chunk;
            this.chunk = WritableObjectChunk.makeWritableChunk(capacity);
            if (oldChunk != null) {
                this.chunk.copyFromTypedChunk(oldChunk, 0, 0, oldChunk.size());
                this.chunk.setSize(oldChunk.size());
                oldChunk.close();
            } else {
                this.chunk.setSize(0);
            }
        }
        return this.chunk;
    }

    public void close() {
        if (this.chunk != null) {
            this.chunk.close();
            this.chunk = null;
        }
    }
}

