/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.sized;

import io.deephaven.chunk.WritableShortChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.util.SafeCloseable;

public final class SizedShortChunk<T extends Any>
implements SafeCloseable {
    private WritableShortChunk<T> chunk;

    public SizedShortChunk() {
    }

    public SizedShortChunk(int initialSize) {
        this.chunk = WritableShortChunk.makeWritableChunk(initialSize);
    }

    public WritableShortChunk<T> get() {
        return this.chunk;
    }

    public WritableShortChunk<T> ensureCapacity(int capacity) {
        if (this.chunk == null || capacity > this.chunk.capacity()) {
            if (this.chunk != null) {
                this.chunk.close();
            }
            this.chunk = WritableShortChunk.makeWritableChunk(capacity);
        }
        return this.chunk;
    }

    public WritableShortChunk<T> ensureCapacityPreserve(int capacity) {
        if (this.chunk == null || capacity > this.chunk.capacity()) {
            WritableShortChunk<T> oldChunk = this.chunk;
            this.chunk = WritableShortChunk.makeWritableChunk(capacity);
            if (oldChunk != null) {
                this.chunk.copyFromTypedChunk(oldChunk, 0, 0, oldChunk.size());
                this.chunk.setSize(oldChunk.size());
                oldChunk.close();
            } else {
                this.chunk.setSize(0);
            }
        }
        return this.chunk;
    }

    public void close() {
        if (this.chunk != null) {
            this.chunk.close();
            this.chunk = null;
        }
    }
}

