/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util;

import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.util.datastructures.LongRangeAbortableConsumer;
import io.deephaven.util.datastructures.LongRangeIterator;

public class LongChunkRangeIterator
implements LongRangeIterator {
    private final LongChunk<? extends Any> ck;
    private final int lastRangeStart;
    private int previousRangeStart;

    public LongChunkRangeIterator(LongChunk<? extends Any> ck) {
        this.ck = ck;
        this.lastRangeStart = ck.size() - 2;
        this.previousRangeStart = -2;
    }

    public boolean hasNext() {
        return this.previousRangeStart < this.lastRangeStart;
    }

    public void next() {
        this.previousRangeStart += 2;
    }

    public long start() {
        return this.ck.get(this.previousRangeStart);
    }

    public long end() {
        return this.ck.get(this.previousRangeStart + 1);
    }

    public boolean forEachLongRange(LongRangeAbortableConsumer lrc) {
        while (this.previousRangeStart < this.lastRangeStart) {
            long e;
            this.previousRangeStart += 2;
            long s = this.ck.get(this.previousRangeStart);
            if (lrc.accept(s, e = this.ck.get(this.previousRangeStart + 1))) continue;
            return false;
        }
        return true;
    }
}

