/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.factories;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.ObjectChunkChunk;
import io.deephaven.chunk.ResettableChunkChunk;
import io.deephaven.chunk.ResettableObjectChunk;
import io.deephaven.chunk.ResettableObjectChunkChunk;
import io.deephaven.chunk.ResettableReadOnlyChunk;
import io.deephaven.chunk.ResettableWritableChunk;
import io.deephaven.chunk.ResettableWritableChunkChunk;
import io.deephaven.chunk.ResettableWritableObjectChunk;
import io.deephaven.chunk.ResettableWritableObjectChunkChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableChunkChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.WritableObjectChunkChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.factories.ChunkFactory;
import java.util.function.IntFunction;
import org.jetbrains.annotations.NotNull;

public final class ObjectChunkFactory<T>
implements ChunkFactory {
    @NotNull
    public final T[] makeArray(int capacity) {
        return WritableObjectChunk.makeArray(capacity);
    }

    @NotNull
    public final <ATTR extends Any> ObjectChunk<T, ATTR>[] makeChunkArray(int capacity) {
        return WritableObjectChunkChunk.makeArray(capacity);
    }

    @NotNull
    public final <ATTR extends Any> ObjectChunk<T, ATTR> getEmptyChunk() {
        return ObjectChunk.getEmptyChunk();
    }

    @NotNull
    public final <ATTR extends Any> ObjectChunkChunk<T, ATTR> getEmptyChunkChunk() {
        return ObjectChunkChunk.getEmptyChunk();
    }

    @NotNull
    public final <ATTR extends Any> ObjectChunk<T, ATTR> chunkWrap(Object array) {
        Object[] typedArray = (Object[])array;
        return ObjectChunk.chunkWrap(typedArray);
    }

    @NotNull
    public final <ATTR extends Any> ObjectChunk<T, ATTR> chunkWrap(Object array, int offset, int capacity) {
        Object[] typedArray = (Object[])array;
        return ObjectChunk.chunkWrap(typedArray, offset, capacity);
    }

    @NotNull
    public final <ATTR extends Any> ObjectChunkChunk<T, ATTR> chunkChunkWrap(Chunk<ATTR>[] array) {
        ObjectChunk[] typedArray = (ObjectChunk[])array;
        return ObjectChunkChunk.chunkWrap(typedArray);
    }

    @NotNull
    public final <ATTR extends Any> ObjectChunkChunk<T, ATTR> chunkChunkWrap(Chunk<ATTR>[] array, int offset, int capacity) {
        ObjectChunk[] typedArray = (ObjectChunk[])array;
        return ObjectChunkChunk.chunkWrap(typedArray, offset, capacity);
    }

    @Override
    @NotNull
    public final <ATTR extends Any> ResettableReadOnlyChunk<ATTR> makeResettableReadOnlyChunk() {
        return ResettableObjectChunk.makeResettableChunk();
    }

    @Override
    @NotNull
    public final <ATTR extends Any> ResettableChunkChunk<ATTR> makeResettableChunkChunk() {
        return ResettableObjectChunkChunk.makeResettableChunk();
    }

    @NotNull
    public final <ATTR extends Any> WritableObjectChunk<T, ATTR> makeWritableChunk(int capacity) {
        return WritableObjectChunk.makeWritableChunk(capacity);
    }

    @NotNull
    public final <ATTR extends Any> WritableObjectChunkChunk<T, ATTR> makeWritableChunkChunk(int capacity) {
        return WritableObjectChunkChunk.makeWritableChunk(capacity);
    }

    @NotNull
    public final <ATTR extends Any> WritableObjectChunk<T, ATTR> writableChunkWrap(Object array, int offset, int capacity) {
        Object[] realType = (Object[])array;
        return WritableObjectChunk.writableChunkWrap(realType, offset, capacity);
    }

    @Override
    @NotNull
    public final <ATTR extends Any> WritableChunkChunk<ATTR> writableChunkChunkWrap(WritableChunk<ATTR>[] array, int offset, int capacity) {
        WritableObjectChunk[] actual = (WritableObjectChunk[])array;
        return WritableObjectChunkChunk.writableChunkWrap(actual, offset, capacity);
    }

    @Override
    @NotNull
    public final <ATTR extends Any> ResettableWritableChunk<ATTR> makeResettableWritableChunk() {
        return ResettableWritableObjectChunk.makeResettableChunk();
    }

    @Override
    @NotNull
    public final <ATTR extends Any> ResettableWritableChunkChunk<ATTR> makeResettableWritableChunkChunk() {
        return ResettableWritableObjectChunkChunk.makeResettableChunk();
    }

    @Override
    @NotNull
    public final IntFunction<Chunk[]> chunkArrayBuilder() {
        return ObjectChunk[]::new;
    }

    @Override
    @NotNull
    public final IntFunction<WritableChunk[]> writableChunkArrayBuilder() {
        return WritableObjectChunk[]::new;
    }
}

