/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.hashing;

import io.deephaven.chunk.BooleanChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.attributes.HashCodes;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.chunk.util.hashing.ChunkHasher;
import io.deephaven.util.type.TypeUtils;

public class BooleanChunkHasher
implements ChunkHasher {
    public static BooleanChunkHasher INSTANCE = new BooleanChunkHasher();

    private static void hashInitial(BooleanChunk<Values> values, WritableIntChunk<HashCodes> destination) {
        for (int ii = 0; ii < values.size(); ++ii) {
            boolean value = values.get(ii);
            destination.set(ii, BooleanChunkHasher.hashInitialSingle(value));
        }
        destination.setSize(values.size());
    }

    private static void hashSecondary(BooleanChunk<Values> values, WritableIntChunk<HashCodes> destination) {
        for (int ii = 0; ii < values.size(); ++ii) {
            destination.set(ii, BooleanChunkHasher.hashUpdateSingle(destination.get(ii), values.get(ii)));
        }
        destination.setSize(values.size());
    }

    public static int hashInitialSingle(boolean value) {
        return ChunkHasher.scrambleHash(Boolean.hashCode(value));
    }

    public static int hashUpdateSingle(int existing, boolean newValue) {
        return existing * 31 + BooleanChunkHasher.hashInitialSingle(newValue);
    }

    @Override
    public int hashInitial(Object value) {
        return BooleanChunkHasher.hashInitialSingle(TypeUtils.unbox((Boolean)((Boolean)value)));
    }

    @Override
    public int hashUpdate(int existing, Object value) {
        return BooleanChunkHasher.hashUpdateSingle(existing, TypeUtils.unbox((Boolean)((Boolean)value)));
    }

    @Override
    public void hashInitial(Chunk<Values> values, WritableIntChunk<HashCodes> destination) {
        BooleanChunkHasher.hashInitial(values.asBooleanChunk(), destination);
    }

    @Override
    public void hashUpdate(Chunk<Values> values, WritableIntChunk<HashCodes> destination) {
        BooleanChunkHasher.hashSecondary(values.asBooleanChunk(), destination);
    }
}

