/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.hashing;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.attributes.HashCodes;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.chunk.util.hashing.ChunkHasher;
import io.deephaven.util.type.TypeUtils;

public class ByteChunkHasher
implements ChunkHasher {
    public static ByteChunkHasher INSTANCE = new ByteChunkHasher();

    private static void hashInitial(ByteChunk<Values> values, WritableIntChunk<HashCodes> destination) {
        for (int ii = 0; ii < values.size(); ++ii) {
            byte value = values.get(ii);
            destination.set(ii, ByteChunkHasher.hashInitialSingle(value));
        }
        destination.setSize(values.size());
    }

    private static void hashSecondary(ByteChunk<Values> values, WritableIntChunk<HashCodes> destination) {
        for (int ii = 0; ii < values.size(); ++ii) {
            destination.set(ii, ByteChunkHasher.hashUpdateSingle(destination.get(ii), values.get(ii)));
        }
        destination.setSize(values.size());
    }

    public static int hashInitialSingle(byte value) {
        return ChunkHasher.scrambleHash(Byte.hashCode(value));
    }

    public static int hashUpdateSingle(int existing, byte newValue) {
        return existing * 31 + ByteChunkHasher.hashInitialSingle(newValue);
    }

    @Override
    public int hashInitial(Object value) {
        return ByteChunkHasher.hashInitialSingle(TypeUtils.unbox((Byte)((Byte)value)));
    }

    @Override
    public int hashUpdate(int existing, Object value) {
        return ByteChunkHasher.hashUpdateSingle(existing, TypeUtils.unbox((Byte)((Byte)value)));
    }

    @Override
    public void hashInitial(Chunk<Values> values, WritableIntChunk<HashCodes> destination) {
        ByteChunkHasher.hashInitial(values.asByteChunk(), destination);
    }

    @Override
    public void hashUpdate(Chunk<Values> values, WritableIntChunk<HashCodes> destination) {
        ByteChunkHasher.hashSecondary(values.asByteChunk(), destination);
    }
}

