/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.hashing;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.hashing.ToIntFunctor;

public class ByteToIntegerCast<T extends Any>
implements ToIntFunctor<T> {
    private final WritableIntChunk<T> result;

    ByteToIntegerCast(int size) {
        this.result = WritableIntChunk.makeWritableChunk(size);
    }

    @Override
    public IntChunk<? extends T> apply(Chunk<? extends T> input) {
        return this.cast(input.asByteChunk());
    }

    private IntChunk<T> cast(ByteChunk<? extends T> input) {
        ByteToIntegerCast.castInto(input, this.result);
        return this.result;
    }

    public static <T2 extends Any> void castInto(ByteChunk<? extends T2> input, WritableIntChunk<T2> result) {
        for (int ii = 0; ii < input.size(); ++ii) {
            result.set(ii, input.get(ii));
        }
        result.setSize(input.size());
    }

    @Override
    public void close() {
        this.result.close();
    }
}

