/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.hashing;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.hashing.ToIntFunctor;

public class ByteToIntegerCastWithOffset<T extends Any>
implements ToIntFunctor<T> {
    private final WritableIntChunk<T> result;
    private final int offset;

    ByteToIntegerCastWithOffset(int size, int offset) {
        this.result = WritableIntChunk.makeWritableChunk(size);
        this.offset = offset;
    }

    @Override
    public IntChunk<? extends T> apply(Chunk<? extends T> input) {
        return this.castWithOffset(input.asByteChunk());
    }

    private IntChunk<T> castWithOffset(ByteChunk<? extends T> input) {
        for (int ii = 0; ii < input.size(); ++ii) {
            this.result.set(ii, input.get(ii) + this.offset);
        }
        this.result.setSize(input.size());
        return this.result;
    }

    @Override
    public void close() {
        this.result.close();
    }
}

